/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.navigator;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.actions.CreateSshContainerAction;
import com.fusesource.ide.fabric.actions.CreateVersionAction;
import com.fusesource.ide.fabric.actions.ProfileAddAction;
import com.fusesource.ide.fabric.actions.jclouds.CreateJCloudsContainerAction;
import com.fusesource.ide.fabric.navigator.Fabric;
import com.fusesource.ide.fabric.navigator.ProfileNode;
import com.fusesource.ide.fabric.navigator.VersionsNode;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.tree.HasRefreshableUI;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableCollectionNode;
import com.fusesource.rider.commons.tree.RefreshableUI;
import com.fusesource.rider.commons.ui.ImageProvider;
import com.fusesource.rider.commons.util.Objects;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;

public class VersionNode
extends RefreshableCollectionNode
implements HasRefreshableUI,
ImageProvider,
ContextMenuProvider {
    private Map<String, ProfileNode> map = new HashMap<String, ProfileNode>();
    private Map<String, Set<Profile>> childrenMap = new HashMap<String, Set<Profile>>();
    private final Fabric fabric;
    private final Version version;

    public VersionNode(VersionsNode parent, Version version) {
        super((Node)parent);
        this.fabric = parent.getFabric();
        this.version = version;
        this.setPropertyBean(version);
    }

    public String toString() {
        return this.version.getName();
    }

    public Version getVersion() {
        return this.version;
    }

    public RefreshableUI getRefreshableUI() {
        return super.getRefreshableUI();
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("version.png");
    }

    protected void loadChildren() {
        Profile profile;
        this.map.clear();
        this.childrenMap.clear();
        Profile[] profiles = this.getVersionProfiles();
        HashMap<String, Profile> profileMap = new HashMap<String, Profile>();
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile[] parents;
            profile = profileArray[n2];
            String id = profile.getId();
            profileMap.put(id, profile);
            Profile[] profileArray2 = parents = profile.getParents();
            int n3 = parents.length;
            int n4 = 0;
            while (n4 < n3) {
                Profile parent = profileArray2[n4];
                String pid = parent.getId();
                Set<Profile> childSet = this.childrenMap.get(pid);
                if (childSet == null) {
                    childSet = new HashSet<Profile>();
                    this.childrenMap.put(pid, childSet);
                }
                childSet.add(profile);
                ++n4;
            }
            ++n2;
        }
        profileArray = profiles;
        n = profiles.length;
        n2 = 0;
        while (n2 < n) {
            profile = profileArray[n2];
            Profile[] parents = profile.getParents();
            if (parents == null | parents.length == 0) {
                ProfileNode node = this.createProfile((Node)this, profile);
                this.addChild((Node)node);
            }
            ++n2;
        }
    }

    public Profile[] getVersionProfiles() {
        return this.version.getProfiles();
    }

    public List<ProfileNode> getAllProfileNodes() {
        ArrayList<ProfileNode> answer = new ArrayList<ProfileNode>();
        Profile[] profiles = this.getVersionProfiles();
        if (profiles != null) {
            Profile[] profileArray = profiles;
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                Profile profile = profileArray[n2];
                ProfileNode node = this.getProfileNode(profile);
                if (node != null) {
                    answer.add(node);
                }
                ++n2;
            }
        }
        Collections.sort(answer);
        return answer;
    }

    public ProfileNode createProfile(Node parent, Profile profile) {
        ProfileNode node = new ProfileNode(this, parent, profile);
        this.map.put(node.getProfileId(), node);
        return node;
    }

    public Fabric getFabric() {
        return this.fabric;
    }

    public String getVersionId() {
        return this.version.getName();
    }

    public ProfileNode getProfileNode(String profileId) {
        this.checkLoaded();
        ProfileNode answer = this.map.get(profileId);
        if (answer == null) {
            answer = ProfileNode.getProfileNode(profileId, this.getProfileChildren());
        }
        return answer;
    }

    public ProfileNode getProfileNode(Profile profile) {
        return this.getProfileNode(profile.getId());
    }

    public ProfileNode[] getProfileChildren() {
        return (ProfileNode[])Objects.getArrayOf((Collection)this.getChildrenList(), ProfileNode.class);
    }

    public <T extends Node> T[] getChildrenOf(Class<T> aType) {
        List list = this.getChildrenList();
        ArrayList<Node> answer = new ArrayList<Node>(list.size());
        for (Node node : list) {
            if (!aType.isInstance(node)) continue;
            answer.add((Node)aType.cast(node));
        }
        Node[] array = (Node[])Array.newInstance(aType, list.size());
        return list.toArray(array);
    }

    public Set<Profile> getChildProfiles(String profileId) {
        return this.childrenMap.get(profileId);
    }

    public void provideContextMenu(IMenuManager menu) {
        menu.add((IAction)new CreateJCloudsContainerAction(this, null, null));
        menu.add((IAction)new CreateSshContainerAction(this, null, null));
        menu.add((IAction)new ProfileAddAction(this));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)new CreateVersionAction(this));
    }
}

