/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.navigator;

import com.fusesource.ide.fabric.FabricConnector;
import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.actions.CreateVersionAction;
import com.fusesource.ide.fabric.navigator.Fabric;
import com.fusesource.ide.fabric.navigator.FabricNodeSupport;
import com.fusesource.ide.fabric.navigator.VersionNode;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.ui.ImageProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.fusesource.fabric.api.Version;

public class VersionsNode
extends FabricNodeSupport
implements ImageProvider,
ContextMenuProvider {
    private Map<String, VersionNode> map = new HashMap<String, VersionNode>();

    public VersionsNode(Fabric fabric) {
        super((Node)fabric, fabric);
    }

    public String toString() {
        return "Versions";
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("version_folder.png");
    }

    protected void loadChildren() {
        this.map.clear();
        FabricConnector connector = this.getFabric().getConnector();
        if (connector == null) {
            return;
        }
        Version[] versions = connector.getVersions();
        if (versions != null) {
            Version[] versionArray = versions;
            int n = versions.length;
            int n2 = 0;
            while (n2 < n) {
                Version version = versionArray[n2];
                VersionNode node = new VersionNode(this, version);
                this.map.put(node.getVersionId(), node);
                this.addChild((Node)node);
                ++n2;
            }
        }
    }

    public VersionNode getVersionNode(String version) {
        return this.map.get(version);
    }

    public VersionNode getDefaultVersionNode() {
        this.checkLoaded();
        List childrenList = this.getChildrenList();
        for (Node node : childrenList) {
            if (!(node instanceof VersionNode)) continue;
            VersionNode answer = (VersionNode)node;
            answer.getChildren();
            return answer;
        }
        return null;
    }

    @Override
    public void provideContextMenu(IMenuManager menu) {
        super.provideContextMenu(menu);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)new CreateVersionAction(this));
    }
}

