/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.navigator.cloud;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.actions.jclouds.CloudDetails;
import com.fusesource.ide.fabric.actions.jclouds.CloudDetailsAddAction;
import com.fusesource.ide.fabric.navigator.cloud.CloudNode;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.tree.HasRefreshableUI;
import com.fusesource.rider.commons.tree.HasViewer;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableCollectionNode;
import com.fusesource.rider.commons.tree.RefreshableUI;
import com.fusesource.rider.commons.ui.ImageProvider;
import com.fusesource.rider.commons.ui.config.ConfigurationDetails;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;

public class CloudsNode
extends RefreshableCollectionNode
implements ImageProvider,
HasRefreshableUI,
ContextMenuProvider {
    private final RefreshableUI refreshableUI;
    private List<CloudNode> cloudNodes = new CopyOnWriteArrayList<CloudNode>();
    private CloudDetailsAddAction addAction;

    public CloudsNode(RefreshableUI refreshableUI) {
        super(null);
        this.refreshableUI = refreshableUI;
        this.addAction = new CloudDetailsAddAction(){

            @Override
            protected void onCloudDetailsAdded(ConfigurationDetails details) {
                RefreshableUI refreshableUI = CloudsNode.this.getRefreshableUI();
                if (refreshableUI instanceof HasViewer) {
                    HasViewer v = (HasViewer)refreshableUI;
                    v.getViewer().setSelection((ISelection)new StructuredSelection((Object)details));
                }
            }
        };
    }

    public RefreshableUI getRefreshableUI() {
        return this.refreshableUI;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("cloud_folder.png");
    }

    public void provideContextMenu(IMenuManager menu) {
        menu.add((IAction)this.addAction);
    }

    public void addChangeListener(IChangeListener listener) {
        this.getCloudDetailList().addChangeListener(listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        this.getCloudDetailList().removeChangeListener(listener);
    }

    protected void loadChildren() {
        WritableList cloudDetailList;
        WritableList list = cloudDetailList = this.getCloudDetailList();
        for (CloudDetails details : list) {
            this.addCloudNode(new CloudNode(this, details));
        }
        cloudDetailList.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                CloudsNode.this.refresh();
            }
        });
    }

    public WritableList getCloudDetailList() {
        return CloudDetails.getCloudDetailList();
    }

    public String toString() {
        return "Clouds";
    }

    public List<CloudNode> getCloudNodes() {
        return this.cloudNodes;
    }

    public CloudNode getCloudNode(String name) {
        for (CloudNode cloudNode : this.cloudNodes) {
            if (!cloudNode.getName().equals(name)) continue;
            return cloudNode;
        }
        return null;
    }

    public void addCloudNode(CloudNode fabric) {
        this.cloudNodes.add(fabric);
        super.addChild((Node)fabric);
    }
}

