/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.navigator.jmx;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.navigator.ContainerNode;
import com.fusesource.ide.fabric.navigator.jmx.JmxNode;
import com.fusesource.ide.jmx.core.ExtensionManager;
import com.fusesource.ide.jmx.core.IConnectionProvider;
import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.ide.jmx.core.IJMXRunnable;
import com.fusesource.ide.jmx.core.JMXCoreMessages;
import com.fusesource.ide.jmx.core.providers.DefaultConnectionProvider;
import com.fusesource.ide.jmx.core.tree.NodeUtils;
import com.fusesource.ide.jmx.core.tree.Root;
import com.fusesource.rider.commons.tree.HasRefreshableUI;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableNode;
import com.fusesource.rider.commons.tree.RefreshableUI;
import com.fusesource.rider.commons.ui.ImageProvider;
import com.fusesource.rider.commons.util.Strings;
import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Image;
import org.fusesource.fabric.service.JmxTemplateSupport;
import org.fusesource.fabric.service.LocalJMXConnector;

public class FabricConnectionWrapper
extends RefreshableNode
implements ImageProvider,
IConnectionWrapper,
HasRefreshableUI {
    private final ContainerNode agentNode;
    private JMXConnector connector;
    private MBeanServerConnection connection;
    private Root root;
    private boolean isConnected;

    public FabricConnectionWrapper(ContainerNode agentNode) {
        super((Node)agentNode);
        this.agentNode = agentNode;
        String jmxUrl = agentNode.getContainer().getJmxUrl();
        this.isConnected = !Strings.isBlank((String)jmxUrl);
    }

    public String toString() {
        return "JMX";
    }

    public IConnectionProvider getProvider() {
        return ExtensionManager.getProvider((String)"com.fusesource.ide.jmx.core.providers.DefaultConnectionProvider");
    }

    public boolean canControl() {
        return true;
    }

    public RefreshableUI getRefreshableUI() {
        return this.agentNode.getRefreshableUI();
    }

    public synchronized void connect() throws IOException {
        this.isConnected = true;
        this.fireConnectionChanged();
        this.refresh();
    }

    public synchronized void disconnect() throws IOException {
        this.root = null;
        this.isConnected = false;
        this.connector = null;
        this.connection = null;
        this.clearChildren();
        this.fireConnectionChanged();
        this.refresh();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public Root getRoot() {
        return this.root;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("releng_gears.gif");
    }

    public void loadRoot() {
        if (this.isConnected && this.root == null) {
            try {
                this.root = NodeUtils.createObjectNameTree((IConnectionWrapper)this);
            }
            catch (CoreException coreException) {
                this.root = new Root((IConnectionWrapper)this);
            }
        }
    }

    protected void loadChildren() {
        this.root = null;
        this.loadChildren((Node)this);
    }

    public void loadChildren(Node parent) {
        this.loadRoot();
        if (this.root != null) {
            Node[] children;
            Node[] nodeArray = children = this.root.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeArray[n2];
                parent.addChild(node);
                ++n2;
            }
        }
    }

    public void run(final IJMXRunnable runnable) throws CoreException {
        try {
            this.agentNode.getJmxTemplate().execute((JmxTemplateSupport.JmxConnectorCallback)new JmxTemplateSupport.JmxConnectorCallback<Object>(){

                public Object doWithJmxConnector(JMXConnector connection) throws Exception {
                    MBeanServerConnection mbeanServerConnection = connection.getMBeanServerConnection();
                    runnable.run(mbeanServerConnection);
                    return null;
                }
            });
        }
        catch (RuntimeException ce) {
            System.out.println("Caught: " + ce);
            ce.printStackTrace();
            Status s = new Status(4, "com.fusesource.ide.jmx.core", JMXCoreMessages.DefaultConnection_ErrorRunningJMXCode, (Throwable)ce);
            throw new CoreException((IStatus)s);
        }
    }

    public JMXConnector getConnector() {
        if (this.connector == null && this.connection != null) {
            this.connector = new LocalJMXConnector(this.connection);
        }
        return this.connector;
    }

    public void loadChildren(JmxNode jmxNode) {
        this.loadRoot();
    }

    protected void fireConnectionChanged() {
        DefaultConnectionProvider provider = (DefaultConnectionProvider)this.getProvider();
        provider.fireChanged((IConnectionWrapper)this);
    }
}

