/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.navigator.maven;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.navigator.ProfileNode;
import com.fusesource.rider.launcher.ui.ExecutePomActionSupport;
import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.cli.MavenCli;
import org.eclipse.core.resources.IContainer;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.m2e.core.MavenPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class FabricDeployAction
extends ExecutePomActionSupport {
    private static final String SERVERS_TAG = "servers";
    private static final String SERVER_TAG = "server";
    private static final String ID_TAG = "id";
    private static final String USERNAME_TAG = "username";
    private static final String PASSWORD_TAG = "password";
    private ProfileNode node;
    private String deployURI;

    public FabricDeployAction(ProfileNode node) {
        super("com.fusesource.fabric.build.tabGroup", "com.fusesource.fabric.build", "deploy");
        this.node = node;
        this.deployURI = this.node.getMavenDeployParameter();
    }

    protected void appendAttributes(IContainer basedir, ILaunchConfigurationWorkingCopy workingCopy, String goal) {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("altDeploymentRepository=" + this.deployURI);
        properties.add("retryFailedDeploymentCount=2");
        workingCopy.setAttribute("M2_PROPERTIES", properties);
        workingCopy.setAttribute("M2_USER_SETTINGS", this.prepareNewSettingsFile());
    }

    private String prepareNewSettingsFile() {
        String userSettings = MavenPlugin.getMavenConfiguration().getUserSettingsFile();
        if (userSettings == null || userSettings.length() == 0) {
            userSettings = MavenCli.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath();
        }
        if (userSettings != null && userSettings.trim().length() > 0) {
            new File(userSettings);
            Document document = this.readFileToDocument(userSettings);
            String fabServerName = this.node.getFabricNameWithoutSpaces();
            boolean entryExists = this.checkForFabricServer(document, fabServerName);
            if (!entryExists) {
                String fabServerUser = this.node.getFabric().getUserName();
                String fabServerPass = this.node.getFabric().getPassword();
                NodeList serversList = document.getElementsByTagName(SERVERS_TAG);
                Element serversElement = null;
                if (serversList.getLength() < 1) {
                    serversElement = document.createElement(SERVERS_TAG);
                    document.getDocumentElement().appendChild(serversElement);
                } else {
                    serversElement = (Element)serversList.item(0);
                }
                Element server = document.createElement(SERVER_TAG);
                serversElement.appendChild(server);
                Element sId = document.createElement(ID_TAG);
                server.appendChild(sId);
                Text textId = document.createTextNode(fabServerName);
                sId.appendChild(textId);
                Element sUser = document.createElement(USERNAME_TAG);
                server.appendChild(sUser);
                Text textUser = document.createTextNode(fabServerUser);
                sUser.appendChild(textUser);
                Element sPass = document.createElement(PASSWORD_TAG);
                server.appendChild(sPass);
                Text textPass = document.createTextNode(fabServerPass);
                sPass.appendChild(textPass);
                File newSettings = null;
                try {
                    try {
                        newSettings = File.createTempFile("mvnSettings_", "_ide.xml");
                        DOMSource source = new DOMSource(document);
                        StreamResult result = new StreamResult(newSettings);
                        Transformer xformer = TransformerFactory.newInstance().newTransformer();
                        xformer.transform(source, result);
                        userSettings = newSettings.getPath();
                    }
                    catch (Exception ex) {
                        FabricPlugin.getLogger().error((Throwable)ex);
                        newSettings.deleteOnExit();
                    }
                }
                finally {
                    newSettings.deleteOnExit();
                }
            }
        }
        return userSettings;
    }

    private boolean checkForFabricServer(Document document, String fabServerName) {
        boolean exists = false;
        NodeList listOfServers = document.getElementsByTagName(SERVER_TAG);
        int numServers = listOfServers.getLength();
        int i = 0;
        while (i < numServers) {
            Element serverElement;
            NodeList idList;
            Element idElement;
            NodeList textFNList;
            String id;
            Node serverNode = listOfServers.item(i);
            if (serverNode.getNodeType() == 1 && (id = (textFNList = (idElement = (Element)(idList = (serverElement = (Element)serverNode).getElementsByTagName(ID_TAG)).item(0)).getChildNodes()).item(0).getNodeValue().trim()).equals(fabServerName)) {
                exists = true;
                break;
            }
            ++i;
        }
        return exists;
    }

    private Document readFileToDocument(String filePath) {
        Document doc = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            File file = new File(filePath);
            if (file.exists() && file.isFile()) {
                doc = docBuilder.parse(file);
            } else {
                doc = docBuilder.newDocument();
                Element root = doc.createElement("settings");
                doc.appendChild(root);
            }
            doc.getDocumentElement().normalize();
        }
        catch (Exception ex) {
            FabricPlugin.getLogger().error((Throwable)ex);
        }
        return doc;
    }
}

