/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.navigator.osgi;

import com.fusesource.ide.fabric.JmxPluginJmxTemplate;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import org.fusesource.fabric.service.JmxTemplateSupport;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.jmx.framework.ServiceStateMBean;

public class OsgiFacade {
    private final JmxPluginJmxTemplate template;
    private ObjectName bundleStateQueryObjectName;
    private ObjectName frameworkQueryObjectName;
    private ObjectName packageQueryObjectName;
    private ObjectName serviceStateQueryObjectName;

    public OsgiFacade(JmxPluginJmxTemplate template) throws MalformedObjectNameException {
        this.template = template;
        this.bundleStateQueryObjectName = new ObjectName("osgi.core:type=bundleState,*");
        this.frameworkQueryObjectName = new ObjectName("osgi.core:type=framework,*");
        this.packageQueryObjectName = new ObjectName("osgi.core:type=packageState,*");
        this.serviceStateQueryObjectName = new ObjectName("osgi.core:type=serviceState,*");
    }

    public void addBundleStateNotificationListener(final NotificationListener listener, final NotificationFilter filter, final Object handback) {
        this.template.execute(new JmxTemplateSupport.JmxConnectorCallback<Void>(){

            public Void doWithJmxConnector(JMXConnector connector) throws Exception {
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                Set<ObjectName> queryNames = connection.queryNames(OsgiFacade.this.bundleStateQueryObjectName, null);
                Iterator<ObjectName> iterator = queryNames.iterator();
                if (iterator.hasNext()) {
                    ObjectName bundleStateObjectName = iterator.next();
                    connection.addNotificationListener(bundleStateObjectName, listener, filter, handback);
                    return null;
                }
                return null;
            }
        });
    }

    public void removeBundleStateNotificationListener(final NotificationListener listener, final NotificationFilter filter, final Object handback) {
        this.template.execute(new JmxTemplateSupport.JmxConnectorCallback<Void>(){

            public Void doWithJmxConnector(JMXConnector connector) throws Exception {
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                Set<ObjectName> queryNames = connection.queryNames(OsgiFacade.this.bundleStateQueryObjectName, null);
                Iterator<ObjectName> iterator = queryNames.iterator();
                if (iterator.hasNext()) {
                    ObjectName bundleStateObjectName = iterator.next();
                    connection.removeNotificationListener(bundleStateObjectName, listener, filter, handback);
                    return null;
                }
                return null;
            }
        });
    }

    public <T> T execute(final BundleStateMBeanCallback<T> callback) {
        return this.template.execute(new JmxTemplateSupport.JmxConnectorCallback<T>(){

            public T doWithJmxConnector(JMXConnector connector) throws Exception {
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                Set<ObjectName> queryNames = connection.queryNames(OsgiFacade.this.bundleStateQueryObjectName, null);
                Iterator<ObjectName> iterator = queryNames.iterator();
                if (iterator.hasNext()) {
                    ObjectName bundleStateObjectName = iterator.next();
                    BundleStateMBean BundleStateMBean2 = MBeanServerInvocationHandler.newProxyInstance(connection, bundleStateObjectName, BundleStateMBean.class, true);
                    return callback.doWithBundleStateMBean(BundleStateMBean2);
                }
                return null;
            }
        });
    }

    public <T> T execute(final ServiceStateMBeanCallback<T> callback) {
        return this.template.execute(new JmxTemplateSupport.JmxConnectorCallback<T>(){

            public T doWithJmxConnector(JMXConnector connector) throws Exception {
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                Set<ObjectName> queryNames = connection.queryNames(OsgiFacade.this.serviceStateQueryObjectName, null);
                Iterator<ObjectName> iterator = queryNames.iterator();
                if (iterator.hasNext()) {
                    ObjectName ServiceStateObjectName = iterator.next();
                    ServiceStateMBean serviceStateMBean = MBeanServerInvocationHandler.newProxyInstance(connection, ServiceStateObjectName, ServiceStateMBean.class, true);
                    return callback.doWithServiceStateMBean(serviceStateMBean);
                }
                return null;
            }
        });
    }

    public <T> T execute(final FrameworkMBeanCallback<T> callback) throws Exception {
        return this.template.executeAndThrow(new JmxTemplateSupport.JmxConnectorCallback<T>(){

            public T doWithJmxConnector(JMXConnector connector) throws Exception {
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                Set<ObjectName> queryNames = connection.queryNames(OsgiFacade.this.frameworkQueryObjectName, null);
                Iterator<ObjectName> iterator = queryNames.iterator();
                if (iterator.hasNext()) {
                    ObjectName FrameworkObjectName = iterator.next();
                    FrameworkMBean mbean = MBeanServerInvocationHandler.newProxyInstance(connection, FrameworkObjectName, FrameworkMBean.class, true);
                    return callback.doWithFrameworkMBean(mbean);
                }
                return null;
            }
        });
    }

    public TabularData listBundles() throws Exception {
        return this.execute(new BundleStateMBeanCallback<TabularData>(){

            @Override
            public TabularData doWithBundleStateMBean(BundleStateMBean bean) throws Exception {
                return bean.listBundles();
            }
        });
    }

    public void startBundle(final long bundleIdentifier) throws Exception {
        this.execute(new FrameworkMBeanCallback<Void>(){

            @Override
            public Void doWithFrameworkMBean(FrameworkMBean mbean) throws Exception {
                mbean.startBundle(bundleIdentifier);
                return null;
            }
        });
    }

    public void startBundles(final long[] bundleIds) throws Exception {
        this.execute(new FrameworkMBeanCallback<Void>(){

            @Override
            public Void doWithFrameworkMBean(FrameworkMBean mbean) throws Exception {
                mbean.startBundles(bundleIds);
                return null;
            }
        });
    }

    public void stopBundle(final long bundleIdentifier) throws Exception {
        this.execute(new FrameworkMBeanCallback<Void>(){

            @Override
            public Void doWithFrameworkMBean(FrameworkMBean mbean) throws Exception {
                mbean.stopBundle(bundleIdentifier);
                return null;
            }
        });
    }

    public void stopBundles(final long[] bundleIds) throws Exception {
        this.execute(new FrameworkMBeanCallback<Void>(){

            @Override
            public Void doWithFrameworkMBean(FrameworkMBean mbean) throws Exception {
                mbean.stopBundles(bundleIds);
                return null;
            }
        });
    }

    public void updateBundles(final long[] bundleIds) throws Exception {
        this.execute(new FrameworkMBeanCallback<Void>(){

            @Override
            public Void doWithFrameworkMBean(FrameworkMBean mbean) throws Exception {
                mbean.updateBundles(bundleIds);
                return null;
            }
        });
    }

    public void updateBundle(final long bundleIdentifier) throws Exception {
        this.execute(new FrameworkMBeanCallback<Void>(){

            @Override
            public Void doWithFrameworkMBean(FrameworkMBean mbean) throws Exception {
                mbean.updateBundle(bundleIdentifier);
                return null;
            }
        });
    }

    public void updateBundleFromURL(final long bundleIdentifier, final String url) throws Exception {
        this.execute(new FrameworkMBeanCallback<Void>(){

            @Override
            public Void doWithFrameworkMBean(FrameworkMBean mbean) throws Exception {
                mbean.updateBundleFromURL(bundleIdentifier, url);
                return null;
            }
        });
    }

    public void refreshBundle(final long bundleIdentifier) throws Exception {
        this.execute(new FrameworkMBeanCallback<Void>(){

            @Override
            public Void doWithFrameworkMBean(FrameworkMBean mbean) throws Exception {
                mbean.refreshBundle(bundleIdentifier);
                return null;
            }
        });
    }

    public void refreshBundles(final long[] bundleIds) throws Exception {
        this.execute(new FrameworkMBeanCallback<Void>(){

            @Override
            public Void doWithFrameworkMBean(FrameworkMBean mbean) throws Exception {
                mbean.refreshBundles(bundleIds);
                return null;
            }
        });
    }

    public void uninstallBundle(final long bundleIdentifier) throws Exception {
        this.execute(new FrameworkMBeanCallback<Void>(){

            @Override
            public Void doWithFrameworkMBean(FrameworkMBean mbean) throws Exception {
                mbean.uninstallBundle(bundleIdentifier);
                return null;
            }
        });
    }

    public void uninstallBundles(final long[] bundleIds) throws Exception {
        this.execute(new FrameworkMBeanCallback<Void>(){

            @Override
            public Void doWithFrameworkMBean(FrameworkMBean mbean) throws Exception {
                mbean.uninstallBundles(bundleIds);
                return null;
            }
        });
    }

    public Long installBundle(final String url, final boolean startOnDeploy) throws Exception {
        return this.execute(new FrameworkMBeanCallback<Long>(){

            @Override
            public Long doWithFrameworkMBean(FrameworkMBean mbean) throws Exception {
                long id = mbean.installBundle(url);
                if (startOnDeploy) {
                    mbean.startBundle(id);
                }
                return id;
            }
        });
    }

    public Long installOrUpdateBundle(final String url, final boolean startOnDeploy) throws Exception {
        return this.execute(new FrameworkMBeanCallback<Long>(){

            @Override
            public Long doWithFrameworkMBean(FrameworkMBean mbean) throws Exception {
                long id = mbean.installBundle(url);
                if (startOnDeploy) {
                    mbean.startBundle(id);
                }
                return id;
            }
        });
    }

    public TabularData listServices() throws Exception {
        return this.execute(new ServiceStateMBeanCallback<TabularData>(){

            @Override
            public TabularData doWithServiceStateMBean(ServiceStateMBean bean) throws Exception {
                return bean.listServices();
            }
        });
    }

    public static interface BundleStateMBeanCallback<T> {
        public T doWithBundleStateMBean(BundleStateMBean var1) throws Exception;
    }

    public static interface FrameworkMBeanCallback<T> {
        public T doWithFrameworkMBean(FrameworkMBean var1) throws Exception;
    }

    public static interface ServiceStateMBeanCallback<T> {
        public T doWithServiceStateMBean(ServiceStateMBean var1) throws Exception;
    }
}

