/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.views;

import com.fusesource.ide.fabric.views.ExchangeBrowsers;
import com.fusesource.ide.fabric.views.MessageDetailView;
import com.fusesource.ide.fabric.views.MessageDragListener;
import com.fusesource.ide.fabric.views.MessageUIHelper;
import com.fusesource.rider.commons.Viewers;
import com.fusesource.rider.commons.ui.views.TableViewSupport;
import com.fusesource.rider.commons.util.Function1;
import com.fusesource.rider.commons.util.FunctionLong;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.fusesource.fon.util.messages.Exchange;
import org.fusesource.fon.util.messages.Exchanges;
import org.fusesource.fon.util.messages.IExchange;
import org.fusesource.fon.util.messages.IExchangeBrowser;
import org.fusesource.fon.util.messages.IMessage;
import org.fusesource.fon.util.messages.ITraceExchangeBrowser;

public class MessagesView
extends TableViewSupport {
    public static final String ID = "com.fusesource.ide.fabric.views.MessagesView";
    IExchangeBrowser browser;
    List<IExchange> exchanges = new ArrayList<IExchange>();
    private boolean showBody = true;
    private boolean showTimestamp = true;
    private boolean showRelativeTime = true;
    private boolean showToNode = true;
    private boolean showTraceExchangeId = true;
    private boolean showElapsedTime = true;

    protected String getHelpID() {
        return ID;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            Object o;
            ISelection selection = this.viewer.getSelection();
            MessageDetailView view = new MessageDetailView();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof Exchange) {
                view.setSelectedExchange((Exchange)o);
            }
            return view;
        }
        return super.getAdapter(adapter);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        if (site != null) {
            site.getWorkbenchWindow().getSelectionService().addSelectionListener(new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (!MessagesView.this.isRelevantSelectionSource(part, selection)) {
                        return;
                    }
                    IExchangeBrowser browser = ExchangeBrowsers.getSelectedExchangeBrowser(selection);
                    MessagesView.this.setExchangeBrowser(browser);
                }
            });
        }
        this.makeActions();
        this.aboutToBeShown();
    }

    private boolean isRelevantSelectionSource(IWorkbenchPart part, ISelection selection) {
        boolean process = false;
        if (part.getClass().getName().equals("com.fusesource.ide.jmx.ui.internal.views.navigator.Navigator") || part.getClass().getName().equals("com.fusesource.ide.fabric.navigator.FabricNavigator") || part.getClass().getName().equals("com.fusesource.rider.editor.views.DiagramView")) {
            process = true;
        }
        return process;
    }

    protected void createViewer() {
        super.createViewer();
        this.getComparator().setDescending(false);
    }

    public void refresh() {
        if (this.browser != null) {
            List list = this.browser.browseExchanges();
            if (list != null) {
                this.exchanges = list;
                if (Viewers.isValid((Viewer)this.viewer)) {
                    this.createViewer();
                }
            }
        } else {
            this.exchanges.clear();
            this.createViewer();
        }
    }

    protected void createColumns() {
        Object function;
        int bounds = 100;
        int column = 0;
        this.clearColumns();
        if (this.browser instanceof ITraceExchangeBrowser) {
            function = new Function1(){

                public Object apply(Object element) {
                    Exchange exchange = Exchanges.asExchange((Object)element);
                    if (exchange != null) {
                        return exchange.getExchangeIndex();
                    }
                    return null;
                }
            };
            column = this.addColumnFunction(bounds, column, (Function1)function, "Trace ID");
        }
        if (this.browser instanceof ITraceExchangeBrowser && this.showTraceExchangeId) {
            function = new Function1(){

                public Object apply(Object element) {
                    Exchange exchange = Exchanges.asExchange((Object)element);
                    if (exchange != null) {
                        return exchange.getId();
                    }
                    return null;
                }
            };
            column = this.addColumnFunction(bounds, column, (Function1)function, "Exchange ID");
        }
        if (this.showBody) {
            function = new Function1(){

                public Object apply(Object element) {
                    IExchange exchange;
                    String answer;
                    if (element instanceof IExchange && (answer = MessageUIHelper.getBody(exchange = (IExchange)element)) != null) {
                        return answer.replace('\n', ' ');
                    }
                    return null;
                }
            };
            column = this.addColumnFunction(bounds, column, (Function1)function, "Message Body");
        }
        TreeSet headers = new TreeSet();
        for (IExchange exchange : this.exchanges) {
            IMessage in = exchange.getIn();
            if (in == null) continue;
            headers.addAll(in.getHeaders().keySet());
        }
        for (final String header : headers) {
            Function1 function2 = new Function1(){

                public Object apply(Object element) {
                    IExchange exchange;
                    IMessage in;
                    if (element instanceof IExchange && (in = (exchange = (IExchange)element).getIn()) != null) {
                        return in.getHeaders().get(header);
                    }
                    return null;
                }
            };
            column = this.addColumnFunction(bounds, column, function2, header);
        }
        if (this.browser instanceof ITraceExchangeBrowser) {
            Object function3;
            if (this.showToNode) {
                function3 = new Function1(){

                    public Object apply(Object element) {
                        IMessage message = Exchanges.asMessage((Object)element);
                        if (message != null) {
                            return message.getToNode();
                        }
                        return null;
                    }
                };
                column = this.addColumnFunction(bounds, column, (Function1)function3, "Trace Node Id");
            }
            if (this.showTimestamp) {
                function3 = new Function1(){

                    public Object apply(Object element) {
                        IMessage message = Exchanges.asMessage((Object)element);
                        if (message != null) {
                            return message.getTimestamp();
                        }
                        return null;
                    }
                };
                column = this.addColumnFunction(bounds, column, (Function1)function3, "Trace Timestamp");
            }
            if (this.showRelativeTime) {
                function3 = new FunctionLong(){

                    public Long apply(Object element) {
                        IMessage message = Exchanges.asMessage((Object)element);
                        if (message != null) {
                            return message.getRelativeTime();
                        }
                        return null;
                    }
                };
                column = this.addColumnFunction(bounds, column, (Function1)function3, "Relative Time (ms)");
            }
            if (this.showElapsedTime) {
                function3 = new FunctionLong(){

                    public Long apply(Object element) {
                        IMessage message = Exchanges.asMessage((Object)element);
                        if (message != null) {
                            return message.getElapsedTime();
                        }
                        return null;
                    }
                };
                column = this.addColumnFunction(bounds, column, (Function1)function3, "Elapsed Time (ms)");
            }
        }
    }

    protected void configureViewer() {
        this.viewer.setInput(this.exchanges);
        new MessageDragListener(this.viewer).register();
    }

    protected IStructuredContentProvider createContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object parent) {
                return MessagesView.this.exchanges.toArray();
            }
        };
    }

    public void setExchangeBrowser(IExchangeBrowser browser) {
        this.browser = browser;
        this.refresh();
    }
}

