/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.views.logs;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.navigator.Fabric;
import com.fusesource.ide.fabric.views.logs.ILogBrowser;
import com.fusesource.ide.fabric.views.logs.LogContext;
import com.fusesource.ide.fabric.views.logs.LogEventBean;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.fusesource.fabric.groups.ZooKeeperGroupFactory;
import org.fusesource.insight.log.LogFilter;
import org.fusesource.insight.log.rest.LogRequest;
import org.fusesource.insight.log.rest.LogResponse;
import org.fusesource.insight.log.rest.LogResponseHit;
import org.fusesource.insight.log.rest.LogResponseHits;
import org.linkedin.zookeeper.client.IZKClient;
import scala.actors.threadpool.Arrays;

public class FabricLogBrowser
implements ILogBrowser {
    protected static final MediaType JSON = MediaType.APPLICATION_JSON_TYPE;
    private final Fabric fabric;
    private Client client;

    public FabricLogBrowser(Fabric fabric) {
        this.fabric = fabric;
    }

    @Override
    public void queryLogs(LogContext context, boolean filterChanged) {
        System.out.println("================ Querying logs.....");
        boolean changeClassLoader = false;
        String path = "/insight/log/_search";
        LogFilter logFilter = context.getLogFilter();
        LogRequest search = LogRequest.newInstance((Long)logFilter.getAfterTimestamp());
        if (this.fabric.getConnector() == null) {
            return;
        }
        IZKClient zooKeeper = this.fabric.getConnector().getZooKeeper();
        Collection<Object> members = Collections.EMPTY_LIST;
        try {
            members = ZooKeeperGroupFactory.members((IZKClient)zooKeeper, (String)"/fabric/registry/clusters/elastic-search").values();
        }
        catch (Exception exception) {
            System.out.println("Warning: " + exception);
        }
        try {
            this.checkClientLoaded(changeClassLoader);
        }
        catch (Throwable throwable) {
            FabricPlugin.getLogger().warning("Could not configure Jersey REST client: " + throwable, throwable);
        }
        if (members.isEmpty()) {
            System.out.println("No elastic search nodes running!");
        }
        for (byte[] byArray : members) {
            String url;
            URI base;
            String uriText;
            try {
                uriText = new String(byArray, "UTF-8");
            }
            catch (Exception e) {
                FabricPlugin.getLogger().warning("Could not parse data: " + Arrays.toString((byte[])byArray) + " into a URI:  " + e, (Throwable)e);
                continue;
            }
            try {
                base = new URI(uriText);
            }
            catch (Exception e) {
                FabricPlugin.getLogger().warning("Failed to parse URI: " + uriText + ". " + e, (Throwable)e);
                continue;
            }
            URI newURI = null;
            try {
                newURI = base.resolve(path);
                url = newURI.toURL().toExternalForm();
                System.out.println("Querying: " + url);
            }
            catch (Exception e) {
                FabricPlugin.getLogger().warning("Failed to create URL from: " + newURI + ". " + e, (Throwable)e);
                continue;
            }
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    List hits2;
                    LogResponseHits hits;
                    this.checkClientLoaded(changeClassLoader);
                    WebResource.Builder resource = this.client.resource(url).type(JSON);
                    LogResponse result = (LogResponse)resource.post(LogResponse.class, (Object)search);
                    if (result != null && (hits = result.getHits()) != null && (hits2 = hits.getHits()) != null) {
                        ArrayList events = Lists.newArrayList();
                        for (LogResponseHit rh : hits2) {
                            Long maxLogSeq;
                            LogEventBean event = LogEventBean.toLogEventBean(rh.getEvent());
                            if (event == null) continue;
                            events.add(event);
                            Long seq = event.getSeq();
                            if (seq == null || (maxLogSeq = logFilter.getAfterTimestamp()) != null && seq <= maxLogSeq) continue;
                            logFilter.setAfterTimestamp(seq);
                        }
                        context.addLogResults(events);
                    }
                }
                catch (Throwable e) {
                    FabricPlugin.getLogger().warning("Failed to fetch logs from: " + newURI + ". " + e, e);
                    if (!changeClassLoader) continue;
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (changeClassLoader) {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
                throw throwable;
            }
            if (!changeClassLoader) continue;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected void checkClientLoaded(boolean changeClassLoader) {
        if (this.client == null) {
            ClassLoader classLoader = FabricPlugin.getDefault().getClass().getClassLoader();
            if (changeClassLoader) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            DefaultClientConfig config = new DefaultClientConfig();
            config.getClasses().add(JacksonJsonProvider.class);
            this.client = Client.create((ClientConfig)config);
            this.client.setFollowRedirects(Boolean.valueOf(true));
            this.client.addFilter((ClientFilter)new LoggingFilter(System.out));
        }
    }
}

