/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.views.logs;

import com.fusesource.ide.fabric.views.logs.LogBrowserSupport;
import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.ide.jmx.core.IJMXRunnable;
import com.fusesource.ide.jmx.core.JMXException;
import com.fusesource.rider.commons.Activator;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.fusesource.fabric.service.JmxTemplateSupport;
import org.fusesource.fabric.service.LocalJMXConnector;
import org.fusesource.insight.log.service.LogQueryCallback;

public class JmxFabricLogBrowser
extends LogBrowserSupport {
    private final IConnectionWrapper connection;
    private JmxTemplateSupport jmxTemplate;

    public JmxFabricLogBrowser(final IConnectionWrapper connection, ObjectName objectName) {
        this.connection = connection;
        this.jmxTemplate = new JmxTemplateSupport(){

            public <T> T execute(final JmxTemplateSupport.JmxConnectorCallback<T> callback) {
                try {
                    connection.run(new IJMXRunnable(){

                        public void run(MBeanServerConnection connection) throws JMXException {
                            LocalJMXConnector connector = new LocalJMXConnector(connection);
                            try {
                                callback.doWithJmxConnector((JMXConnector)connector);
                            }
                            catch (JMXException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new JMXException(e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Activator.getLogger().warning("Failed to query logs: " + e, (Throwable)e);
                }
                return null;
            }
        };
    }

    @Override
    protected <T> T execute(LogQueryCallback<T> callback) {
        return (T)this.jmxTemplate.execute(callback);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmxFabricLogBrowser other = (JmxFabricLogBrowser)obj;
        return !(this.connection == null ? other.connection != null : !this.connection.equals(other.connection));
    }
}

