/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.views.logs;

import com.fusesource.ide.fabric.views.logs.ILogBrowser;
import com.fusesource.ide.fabric.views.logs.JsonHelper;
import com.fusesource.ide.fabric.views.logs.LogContext;
import com.fusesource.ide.fabric.views.logs.LogEventBean;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.fusesource.insight.log.LogEvent;
import org.fusesource.insight.log.LogFilter;
import org.fusesource.insight.log.LogResults;
import org.fusesource.insight.log.service.LogQueryCallback;
import org.fusesource.insight.log.service.LogQueryMBean;

public abstract class LogBrowserSupport
implements ILogBrowser {
    private ObjectMapper mapper = new ObjectMapper();

    public LogBrowserSupport() {
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void queryLogs(final LogContext context, boolean filterChanged) throws IOException {
        final LogFilter logFilter = context.getLogFilter();
        final String queryJson = JsonHelper.toJSON(this.mapper, logFilter);
        LogQueryCallback<List<LogEventBean>> callback = new LogQueryCallback<List<LogEventBean>>(){

            public List<LogEventBean> doWithLogQuery(LogQueryMBean mbean) throws Exception {
                LogResults results;
                String json = mbean.filterLogEvents(queryJson);
                ArrayList answer = Lists.newArrayList();
                if (json != null && !(json = json.trim()).equals("[]") && json.length() > 2 && (results = (LogResults)LogBrowserSupport.this.mapper.reader(LogResults.class).readValue(json)) != null) {
                    List events;
                    Long to = results.getToTimestamp();
                    if (to != null) {
                        logFilter.setAfterTimestamp(to);
                    }
                    if ((events = results.getEvents()) != null) {
                        for (LogEvent event : events) {
                            if (event.getHost() == null) {
                                event.setHost(results.getHost());
                            }
                            answer.add(LogEventBean.toLogEventBean(event));
                        }
                    }
                }
                context.addLogResults(answer);
                return answer;
            }
        };
        this.execute(callback);
    }

    protected abstract <T> T execute(LogQueryCallback<T> var1);
}

