/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.views.logs;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.rider.commons.util.BeanSupport;
import com.google.common.base.Joiner;
import java.util.Date;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.eclipse.swt.graphics.Image;
import org.fusesource.insight.log.LogEvent;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LogEventBean
extends BeanSupport
implements Comparable<LogEventBean> {
    protected static final transient Joiner newlineJoiner = Joiner.on((String)"/n");
    private final LogEvent event;

    public static LogEventBean toLogEventBean(Object element) {
        if (element instanceof LogEventBean) {
            return (LogEventBean)element;
        }
        if (element instanceof LogEvent) {
            LogEvent event = (LogEvent)element;
            return new LogEventBean(event);
        }
        return null;
    }

    public LogEventBean(LogEvent event) {
        this.event = event;
    }

    public LogEventBean() {
        this(new LogEvent());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogEventBean other = (LogEventBean)obj;
        return !(this.event == null ? other.event != null : !this.event.equals((Object)other.event));
    }

    @Override
    public int compareTo(LogEventBean that) {
        return this.event.compareTo(that.event);
    }

    public String getExceptionText() {
        Object[] exception = this.getException();
        if (exception == null) {
            return "";
        }
        return newlineJoiner.join(exception);
    }

    public Image getLevelImage() {
        String l = this.getLevel();
        if (l != null) {
            if ("INFO".equalsIgnoreCase(l)) {
                return FabricPlugin.getDefault().getImage("information.gif");
            }
            if ("ERROR".equalsIgnoreCase(l)) {
                return FabricPlugin.getDefault().getImage("error.gif");
            }
            if ("WARN".equalsIgnoreCase(l)) {
                return FabricPlugin.getDefault().getImage("warning.gif");
            }
        }
        return null;
    }

    public String getClassName() {
        return this.event.getClassName();
    }

    public String[] getException() {
        return this.event.getException();
    }

    public String getFileName() {
        return this.event.getFileName();
    }

    public String getHost() {
        return this.event.getHost();
    }

    public String getContainer() {
        return this.event.getContainerName();
    }

    public String getLevel() {
        return this.event.getLevel();
    }

    public String getLineNumber() {
        return this.event.getLineNumber();
    }

    public String getLogger() {
        return this.event.getLogger();
    }

    public String getMessage() {
        return this.event.getMessage();
    }

    public String getMethodName() {
        return this.event.getMethodName();
    }

    public Map<String, String> getProperties() {
        return this.event.getProperties();
    }

    public Long getSeq() {
        return this.event.getSeq();
    }

    public String getThread() {
        return this.event.getThread();
    }

    public Date getTimestamp() {
        return this.event.getTimestamp();
    }

    public void setClassName(String className) {
        this.event.setClassName(className);
    }

    public void setException(String[] exception) {
        this.event.setException(exception);
    }

    public void setFileName(String fileName) {
        this.event.setFileName(fileName);
    }

    public void setHost(String host) {
        this.event.setHost(host);
    }

    public void setContainer(String containerName) {
        this.event.setContainerName(containerName);
    }

    public void setLevel(String level) {
        this.event.setLevel(level);
    }

    public void setLineNumber(String lineNumber) {
        this.event.setLineNumber(lineNumber);
    }

    public void setLogger(String logger) {
        this.event.setLogger(logger);
    }

    public void setMessage(String message) {
        this.event.setMessage(message);
    }

    public void setMethodName(String methodName) {
        this.event.setMethodName(methodName);
    }

    public void setProperties(Map<String, String> properties) {
        this.event.setProperties(properties);
    }

    public void setSeq(Long seq) {
        this.event.setSeq(seq);
    }

    public void setThread(String thread) {
        this.event.setThread(thread);
    }

    public void setTimestamp(Date timestamp) {
        this.event.setTimestamp(timestamp);
    }

    public String toString() {
        return this.event.toString();
    }
}

