/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.views.logs;

import com.fusesource.ide.fabric.views.logs.ILogBrowser;
import com.fusesource.ide.fabric.views.logs.LogContext;
import com.fusesource.ide.fabric.views.logs.LogDetailForm;
import com.fusesource.ide.fabric.views.logs.LogEventBean;
import com.fusesource.ide.fabric.views.logs.LogMessages;
import com.fusesource.ide.fabric.views.logs.Logs;
import com.fusesource.ide.fabric.views.logs.actions.OpenStackTraceAction;
import com.fusesource.rider.commons.Activator;
import com.fusesource.rider.commons.Viewers;
import com.fusesource.rider.commons.jobs.Jobs;
import com.fusesource.rider.commons.ui.Menus;
import com.fusesource.rider.commons.ui.Selections;
import com.fusesource.rider.commons.ui.Widgets;
import com.fusesource.rider.commons.ui.form.FormPropertySheetPage;
import com.fusesource.rider.commons.ui.form.FormSupport;
import com.fusesource.rider.commons.ui.views.TableViewSupport;
import com.fusesource.rider.commons.util.Function1;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.fusesource.insight.log.LogFilter;

public class LogsView
extends TableViewSupport
implements LogContext {
    public static final String ID = LogsView.class.getName();
    private static Joiner joiner = Joiner.on((String)"\n");
    private ILogBrowser browser;
    private final Set<LogEventBean> logEventList = Collections.synchronizedSet(new TreeSet());
    private long logPollTime = 5000L;
    private Job job;
    private boolean newColumnsMayAppear = false;
    private boolean columnsEverChange = false;
    private LogFilter logFilter = new LogFilter();
    private boolean filterChanged;
    private OpenStackTraceAction openStackAction;

    public LogsView() {
        this.logFilter.setCount(50);
        this.getComparator().setDescending(false);
        this.job = new Job("Querying logs"){

            protected IStatus run(IProgressMonitor monitor) {
                LogsView.this.queryLogs();
                if (!Widgets.isDisposed((Control)LogsView.this.getControl())) {
                    Jobs.schedule((long)LogsView.this.logPollTime, (Job)this);
                } else {
                    System.out.println("Control disposed to not rescheduling query job");
                }
                return Status.OK_STATUS;
            }
        };
        this.job.setSystem(true);
        this.openStackAction = new OpenStackTraceAction(this, LogMessages.openStackTrace);
        this.setDoubleClickAction(this.openStackAction);
    }

    protected String getHelpID() {
        return ID;
    }

    protected void addToolBarActions(IToolBarManager manager) {
        super.addToolBarActions(manager);
        Menus.addAction((IContributionManager)manager, (Object)((Object)this.openStackAction));
    }

    protected void addLocalMenus(IMenuManager manager) {
        super.addLocalMenus(manager);
        Menus.addAction((IContributionManager)manager, (Object)((Object)this.openStackAction));
    }

    protected void removeToolBarActions(IToolBarManager manager) {
        Menus.removeAction((IContributionManager)manager, (Object)((Object)this.openStackAction));
        super.removeToolBarActions(manager);
    }

    protected void removeLocalMenus(IMenuManager manager) {
        Menus.removeAction((IContributionManager)manager, (Object)((Object)this.openStackAction));
        super.removeLocalMenus(manager);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            this.viewer.getSelection();
            return new FormPropertySheetPage((FormSupport)new LogDetailForm());
        }
        return super.getAdapter(adapter);
    }

    @Override
    public LogFilter getLogFilter() {
        return this.logFilter;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        if (site != null) {
            site.getWorkbenchWindow().getSelectionService().addSelectionListener(new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (part instanceof LogsView) {
                        return;
                    }
                    ILogBrowser browser = Logs.getSelectionLogBrowser(selection);
                    LogsView.this.setExchangeBrowser(browser);
                }
            });
        }
        this.makeActions();
        this.aboutToBeShown();
        this.job.schedule();
    }

    public LogEventBean getSelectedEvent() {
        return LogEventBean.toLogEventBean(Selections.getFirstSelection((Viewer)this.getViewer()));
    }

    public void dispose() {
        this.job.cancel();
        super.dispose();
    }

    protected void queryLogs() {
        try {
            if (!Widgets.isValidFromOtherThread((Widget)this.getControl())) {
                System.out.println("Control not valid so not querying logs...");
                return;
            }
            boolean value = this.filterChanged;
            if (this.browser != null) {
                this.filterChanged = false;
                if (value) {
                    this.logFilter.setAfterTimestamp(null);
                    this.logFilter.setBeforeTimestamp(null);
                }
                this.browser.queryLogs(this, value);
            }
        }
        catch (Throwable e) {
            Activator.getLogger().warning("Failed to query logs: " + e, e);
        }
    }

    @Override
    public void addLogResults(final List<LogEventBean> events) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (LogEventBean event : events) {
                    if (event == null) continue;
                    LogsView.this.logEventList.add(event);
                }
                LogsView.this.onLogEventsChanged();
            }
        });
    }

    protected void onLogEventsChanged() {
        if (this.columnsEverChange) {
            if (this.newColumnsMayAppear) {
                this.createViewer();
            } else {
                this.recreateColumns();
                Viewers.refresh((Viewer)this.getViewer());
            }
        } else {
            Viewers.refresh((Viewer)this.getViewer());
        }
    }

    protected void setLogEvents(final List<LogEventBean> list) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LogsView.this.logEventList.clear();
                LogsView.this.logEventList.addAll(list);
                LogsView.this.onLogEventsChanged();
            }
        });
    }

    protected void createViewer() {
        super.createViewer();
    }

    public void refresh() {
        this.job.schedule();
    }

    protected void createColumns() {
        int bounds = 100;
        int column = 0;
        this.clearColumns();
        Object function = new Function1(){

            public Object apply(Object element) {
                LogEventBean log = Logs.toLogEvent(element);
                if (log != null) {
                    return log.getTimestamp();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Time");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventBean log = Logs.toLogEvent(element);
                if (log != null) {
                    return log.getHost();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Host");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventBean log = Logs.toLogEvent(element);
                if (log != null) {
                    return log.getContainer();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Container");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventBean log = Logs.toLogEvent(element);
                if (log != null) {
                    return log.getLevel();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Level");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventBean log = Logs.toLogEvent(element);
                if (log != null) {
                    return log.getLogger();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Category");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventBean log = Logs.toLogEvent(element);
                if (log != null) {
                    return log.getThread();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Thread");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventBean log = Logs.toLogEvent(element);
                if (log != null) {
                    return log.getMessage();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Message");
        function = new Function1(){

            public Object apply(Object element) {
                return element;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Location");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventBean log = Logs.toLogEvent(element);
                if (log != null) {
                    return log.getProperties();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Properties");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventBean log = Logs.toLogEvent(element);
                if (log != null) {
                    return log.getSeq();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "ID");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventBean log = Logs.toLogEvent(element);
                if (log != null) {
                    Object[] exception = log.getException();
                    if (exception != null) {
                        return joiner.join(exception);
                    }
                    return exception;
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Exception");
    }

    protected void configureViewer() {
        this.setInput(this.logEventList);
    }

    protected IStructuredContentProvider createContentProvider() {
        return ArrayContentProvider.getInstance();
    }

    public void setExchangeBrowser(ILogBrowser browser) {
        if (!Objects.equal((Object)this.browser, (Object)browser)) {
            this.browser = browser;
            this.filterChanged = true;
            this.logEventList.clear();
            this.setInput(this.logEventList);
            Viewers.refreshAsync((Viewer)this.getViewer());
        }
        this.refresh();
    }

    protected void onFilterChanged() {
        this.filterChanged = true;
        super.onFilterChanged();
        this.refresh();
    }
}

