/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.action;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.ShowSummaryFieldDialog;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AbstractCrosstabAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.ui.extension.IAggregationCellViewProvider;
import org.eclipse.birt.report.item.crosstab.ui.extension.SwitchCellInfo;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class AddMeasureViewHandleAction
extends AbstractCrosstabAction {
    private MeasureViewHandle measureViewHandle;
    boolean needUpdateView = false;
    public static final String ID = "org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AddMesureViewHandleAction";
    private static final String NAME = Messages.getString("AddMesureViewHandleAction.DisplayName");
    private static final String ACTION_MSG_MERGE = Messages.getString("AddMesureViewHandleAction.TransName");
    private AggregationCellProviderWrapper providerWrapper;

    public AddMeasureViewHandleAction(DesignElementHandle handle) {
        super(handle);
        this.setId(ID);
        this.setText(NAME);
        ExtendedItemHandle extendedHandle = CrosstabAdaptUtil.getExtendedItemHandle(handle);
        this.setHandle((DesignElementHandle)extendedHandle);
        this.measureViewHandle = CrosstabAdaptUtil.getMeasureViewHandle(extendedHandle);
        Image image = CrosstabUIHelper.getImage("icons/pal/show-hide-level.gif");
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
    }

    public boolean isEnabled() {
        CubeHandle cubeHandle = this.measureViewHandle.getCrosstab().getCube();
        if (cubeHandle == null) {
            return false;
        }
        return !DEUtil.isReferenceElement((DesignElementHandle)this.measureViewHandle.getCrosstabHandle());
    }

    private String getExpectedView(MeasureViewHandle measure) {
        String view = "";
        AggregationCellHandle cell = measure.getCell();
        AggregationCellProviderWrapper wrapper = new AggregationCellProviderWrapper(measure.getCrosstab());
        IAggregationCellViewProvider provider = wrapper.getMatchProvider(cell);
        if (provider != null) {
            view = provider.getViewName();
        }
        return view;
    }

    public void run() {
        this.transStar(ACTION_MSG_MERGE);
        try {
            CrosstabReportItemHandle reportHandle = this.measureViewHandle.getCrosstab();
            ShowSummaryFieldDialog dialog = new ShowSummaryFieldDialog(UIUtil.getDefaultShell(), reportHandle);
            List list = this.getDimensionHandles();
            ArrayList<ShowSummaryFieldDialog.MeasureInfo> input = new ArrayList<ShowSummaryFieldDialog.MeasureInfo>();
            int i = 0;
            while (i < list.size()) {
                MeasureHandle handle = (MeasureHandle)list.get(i);
                ShowSummaryFieldDialog.MeasureInfo info = new ShowSummaryFieldDialog.MeasureInfo();
                info.setMeasureName(handle.getQualifiedName());
                info.setMeasureDisplayName(handle.getName());
                info.setExpectedView("");
                input.add(info);
                ++i;
            }
            int count = reportHandle.getMeasureCount();
            int i2 = 0;
            while (i2 < count) {
                MeasureViewHandle viewHandle = reportHandle.getMeasure(i2);
                if (viewHandle != null) {
                    if (viewHandle instanceof ComputedMeasureViewHandle) {
                        ShowSummaryFieldDialog.MeasureInfo info = new ShowSummaryFieldDialog.MeasureInfo();
                        info.setMeasureName(viewHandle.getCubeMeasureName());
                        info.setMeasureDisplayName(viewHandle.getCubeMeasureName());
                        info.setExpectedView("");
                        info.setShow(true);
                        input.add(info);
                    } else {
                        this.checkStatus(viewHandle, input);
                    }
                }
                ++i2;
            }
            dialog.setInput(this.copyInfo(input));
            if (dialog.open() == 0) {
                List result = (List)dialog.getResult();
                boolean isRemove = this.processor(input, result, false);
                if (isRemove) {
                    boolean bool = CrosstabAdaptUtil.needRemoveInvaildBindings(reportHandle);
                    this.processor(input, result, true);
                    if (bool) {
                        CrosstabAdaptUtil.removeInvalidBindings(reportHandle);
                    }
                } else {
                    this.processor(input, result, true);
                }
                this.providerWrapper.switchViews();
                if (this.needUpdateView) {
                    this.providerWrapper.updateAllAggregationCells(0);
                }
            }
        }
        catch (SemanticException e) {
            this.rollBack();
            ExceptionUtil.handle((Throwable)e);
            return;
        }
        this.transEnd();
    }

    private void initializeProviders() {
        this.providerWrapper = new AggregationCellProviderWrapper((ExtendedItemHandle)this.measureViewHandle.getCrosstab().getModelHandle());
    }

    private ShowSummaryFieldDialog.MeasureInfo getOriMeasureInfo(ShowSummaryFieldDialog.MeasureInfo info, List list) {
        ShowSummaryFieldDialog.MeasureInfo ret = null;
        int i = 0;
        while (i < list.size()) {
            ShowSummaryFieldDialog.MeasureInfo comparedOne = (ShowSummaryFieldDialog.MeasureInfo)list.get(i);
            if (info.isSameInfo(comparedOne)) {
                return comparedOne;
            }
            ++i;
        }
        return ret;
    }

    private MeasureViewHandle findMeasureViewHandle(MeasureHandle measure) {
        return this.measureViewHandle.getCrosstab().getMeasure(measure.getQualifiedName());
    }

    private boolean processor(List list, List result, boolean doChange) throws SemanticException {
        this.initializeProviders();
        boolean isRemove = false;
        ArrayList temp = new ArrayList(result);
        int i = 0;
        while (i < result.size()) {
            ShowSummaryFieldDialog.MeasureInfo resultOne = (ShowSummaryFieldDialog.MeasureInfo)result.get(i);
            ShowSummaryFieldDialog.MeasureInfo originalOne = this.getOriMeasureInfo(resultOne, list);
            if (resultOne.isShow() == originalOne.isShow()) {
                ShowSummaryFieldDialog.MeasureInfo info = (ShowSummaryFieldDialog.MeasureInfo)result.get(i);
                if (info.isShow() && info.getExpectedView() != null && info.getExpectedView().length() != 0) {
                    SwitchCellInfo swtichCellInfo = new SwitchCellInfo(this.measureViewHandle.getCrosstab(), 3);
                    swtichCellInfo.setMeasureInfo(info);
                    swtichCellInfo.setIsNew(false);
                    this.providerWrapper.addSwitchInfo(swtichCellInfo);
                    this.needUpdateView = true;
                }
                temp.remove(resultOne);
            }
            ++i;
        }
        CrosstabReportItemHandle reportHandle = this.measureViewHandle.getCrosstab();
        int i2 = 0;
        while (i2 < temp.size()) {
            ShowSummaryFieldDialog.MeasureInfo info = (ShowSummaryFieldDialog.MeasureInfo)temp.get(i2);
            if (info.isShow()) {
                if (doChange) {
                    MeasureHandle measure = reportHandle.getCube().getMeasure(info.getMeasureName());
                    MeasureViewHandle measureViewHandle = reportHandle.insertMeasure(measure, reportHandle.getMeasureCount());
                    measureViewHandle.addHeader();
                    this.needUpdateView = true;
                    if (info.getExpectedView() != null && info.getExpectedView().length() != 0) {
                        SwitchCellInfo swtichCellInfo = new SwitchCellInfo(measureViewHandle.getCrosstab(), 3);
                        info.setMeasureName(measureViewHandle.getCubeMeasure().getQualifiedName());
                        swtichCellInfo.setMeasureInfo(info);
                        swtichCellInfo.setIsNew(true);
                        this.providerWrapper.addSwitchInfo(swtichCellInfo);
                    }
                }
            } else {
                if (doChange) {
                    reportHandle.removeMeasure(info.getMeasureName());
                }
                isRemove = true;
                this.needUpdateView = true;
            }
            ++i2;
        }
        return isRemove;
    }

    private void checkStatus(MeasureViewHandle viewHandle, List list) {
        int i = 0;
        while (i < list.size()) {
            ShowSummaryFieldDialog.MeasureInfo info = (ShowSummaryFieldDialog.MeasureInfo)list.get(i);
            if (info.getMeasureName().equals(viewHandle.getCubeMeasureName())) {
                info.setShow(true);
                String view = this.getExpectedView(viewHandle);
                info.setExpectedView(view);
                break;
            }
            ++i;
        }
    }

    private List copyInfo(List list) {
        ArrayList<ShowSummaryFieldDialog.MeasureInfo> retValue = new ArrayList<ShowSummaryFieldDialog.MeasureInfo>();
        int i = 0;
        while (i < list.size()) {
            retValue.add(((ShowSummaryFieldDialog.MeasureInfo)list.get(i)).copy());
            ++i;
        }
        return retValue;
    }

    private List getDimensionHandles() {
        ArrayList retValue = new ArrayList();
        CubeHandle cubeHandle = this.measureViewHandle.getCrosstab().getCube();
        List list = cubeHandle.getContents("measureGroups");
        int i = 0;
        while (i < list.size()) {
            MeasureGroupHandle groupHandle = (MeasureGroupHandle)list.get(i);
            List tempList = groupHandle.getContents("measures");
            retValue.addAll(tempList);
            ++i;
        }
        return retValue;
    }
}

