/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public abstract class ChainedJob
extends Job {
    private Job nextJob;
    private IJobChangeListener listener;
    private String family;

    public ChainedJob(String name, String family) {
        super(name);
        this.family = family;
    }

    public boolean belongsTo(Object family) {
        return family.equals(family);
    }

    protected void createListener() {
        if (this.listener != null) {
            return;
        }
        this.listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ChainedJob.this.jobDone(event.getResult());
            }
        };
        this.addJobChangeListener(this.listener);
    }

    protected void jobDone(IStatus status) {
        if (this.listener == null) {
            return;
        }
        this.removeJobChangeListener(this.listener);
        this.listener = null;
        if (this.nextJob != null && status != null && status.getSeverity() != 4 && status.getSeverity() != 8) {
            this.nextJob.schedule();
        }
    }

    public void setNextJob(Job job) {
        this.nextJob = job;
        this.createListener();
    }
}

