/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.core;

import com.fusesource.ide.jmx.core.MBeanInfoWrapper;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.core.runtime.Assert;

public class DomainWrapper {
    private final String name;
    private final MBeanServerConnection mbsc;

    public DomainWrapper(String name, MBeanServerConnection mbsc) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)mbsc);
        this.name = name;
        this.mbsc = mbsc;
    }

    private ObjectName getPattern() throws MalformedObjectNameException {
        return new ObjectName(String.valueOf(this.name) + ":*");
    }

    public String getName() {
        return this.name;
    }

    public MBeanInfoWrapper[] getMBeanInfos() {
        try {
            Set<ObjectName> set = this.mbsc.queryNames(this.getPattern(), null);
            MBeanInfoWrapper[] instances = new MBeanInfoWrapper[set.size()];
            int i = 0;
            for (ObjectName on : set) {
                MBeanInfo info = this.mbsc.getMBeanInfo(on);
                instances[i] = new MBeanInfoWrapper(on, info, this.mbsc);
                ++i;
            }
            return instances;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new MBeanInfoWrapper[0];
        }
    }
}

