/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.core;

import com.fusesource.ide.jmx.core.IConnectionProvider;
import com.fusesource.ide.jmx.core.IConnectionProviderListener;
import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.ide.jmx.core.JMXActivator;
import com.fusesource.ide.jmx.core.JMXCoreMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class ExtensionManager {
    public static final String MBEAN_CONNECTION = "com.fusesource.ide.jmx.core.MBeanServerConnectionProvider";
    public static final String CLASS = "class";
    private static HashMap<String, IConnectionProvider> providers;

    public static IConnectionProvider[] getProviders() {
        if (providers == null) {
            ExtensionManager.loadExtensions();
        }
        return providers.values().toArray(new IConnectionProvider[providers.values().size()]);
    }

    public static IConnectionProvider getProvider(String id) {
        if (providers == null) {
            ExtensionManager.loadExtensions();
        }
        return providers.get(id);
    }

    public static IConnectionWrapper[] getAllConnections() {
        if (providers == null) {
            ExtensionManager.loadExtensions();
        }
        ArrayList<IConnectionWrapper> l = new ArrayList<IConnectionWrapper>();
        Iterator<IConnectionProvider> i = providers.values().iterator();
        while (i.hasNext()) {
            l.addAll(Arrays.asList(i.next().getConnections()));
        }
        return l.toArray(new IConnectionWrapper[l.size()]);
    }

    public static void loadExtensions() {
        HashMap<String, IConnectionProvider> tmp = new HashMap<String, IConnectionProvider>();
        IExtension[] extensions = ExtensionManager.findExtension(MBEAN_CONNECTION);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                Status s;
                try {
                    IConnectionProvider o = (IConnectionProvider)elements[j].createExecutableExtension(CLASS);
                    tmp.put(o.getId(), o);
                }
                catch (InvalidRegistryObjectException e) {
                    s = new Status(4, "com.fusesource.ide.jmx.core", JMXCoreMessages.ExtensionManagerError1, (Throwable)e);
                    JMXActivator.log((IStatus)s);
                }
                catch (CoreException e) {
                    s = new Status(4, "com.fusesource.ide.jmx.core", JMXCoreMessages.ExtensionManagerError1, (Throwable)e);
                    JMXActivator.log((IStatus)s);
                }
                ++j;
            }
            ++i;
        }
        providers = tmp;
    }

    private static IExtension[] findExtension(String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionId);
        return extensionPoint.getExtensions();
    }

    public static void addConnectionProviderListener(IConnectionProviderListener listener) {
        IConnectionProvider[] providers2 = ExtensionManager.getProviders();
        int i = 0;
        while (i < providers2.length) {
            providers2[i].addListener(listener);
            ++i;
        }
    }

    public static void removeConnectionProviderListener(IConnectionProviderListener listener) {
        IConnectionProvider[] providers2 = ExtensionManager.getProviders();
        int i = 0;
        while (i < providers2.length) {
            providers2[i].removeListener(listener);
            ++i;
        }
    }
}

