/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.core;

import com.fusesource.ide.jmx.core.tree.NodeProvider;
import com.fusesource.rider.commons.logging.RiderLogFacade;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class JMXActivator
extends Plugin {
    public static final String PLUGIN_ID = "com.fusesource.ide.jmx.core";
    private static JMXActivator plugin;
    private static List<NodeProvider> nodeProviders;

    static {
        nodeProviders = new CopyOnWriteArrayList<NodeProvider>();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static JMXActivator getDefault() {
        return plugin;
    }

    public static RiderLogFacade getLogger() {
        return RiderLogFacade.getLog((ILog)JMXActivator.getDefault().getLog());
    }

    public static void log(IStatus status) {
        JMXActivator.getDefault().getLog().log(status);
    }

    public static void log(int severity, String message, Throwable e) {
        JMXActivator.log((IStatus)new Status(severity, PLUGIN_ID, 0, message, e));
    }

    public static void addNodeProvider(NodeProvider nodeProvider) {
        if (!nodeProviders.contains(nodeProvider)) {
            nodeProviders.add(nodeProvider);
        }
    }

    public static void removeNodeProvider(NodeProvider nodeProvider) {
        nodeProviders.remove(nodeProvider);
    }

    public static List<NodeProvider> getNodeProviders() {
        return nodeProviders;
    }
}

