/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.core.providers;

import com.fusesource.ide.jmx.core.IConnectionProvider;
import com.fusesource.ide.jmx.core.IConnectionProviderListener;
import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.ide.jmx.core.IMemento;
import com.fusesource.ide.jmx.core.JMXActivator;
import com.fusesource.ide.jmx.core.JMXCoreMessages;
import com.fusesource.ide.jmx.core.providers.AutomaticStarter;
import com.fusesource.ide.jmx.core.providers.DefaultConnectionWrapper;
import com.fusesource.ide.jmx.core.providers.MBeanServerConnectionDescriptor;
import com.fusesource.ide.jmx.core.util.XMLMemento;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DefaultConnectionProvider
implements IConnectionProvider {
    public static final String PROVIDER_ID = "com.fusesource.ide.jmx.core.providers.DefaultConnectionProvider";
    public static final String ID = "id";
    public static final String URL = "url";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String CONNECTION = "connection";
    public static final String CONNECTIONS = "connections";
    public static final String STORE_FILE = "defaultConnections.xml";
    private ArrayList<IConnectionProviderListener> listeners = new ArrayList();
    private HashMap<String, DefaultConnectionWrapper> connections;

    public DefaultConnectionProvider() {
        this.addListener(new AutomaticStarter());
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public void addListener(IConnectionProviderListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(IConnectionProviderListener listener) {
        this.listeners.remove(listener);
    }

    void fireAdded(IConnectionWrapper wrapper) {
        Iterator<IConnectionProviderListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            try {
                i.next().connectionAdded(wrapper);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    public void fireChanged(IConnectionWrapper wrapper) {
        Iterator<IConnectionProviderListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            try {
                IConnectionProviderListener next = i.next();
                next.connectionChanged(wrapper);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    void fireRemoved(IConnectionWrapper wrapper) {
        Iterator<IConnectionProviderListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            try {
                i.next().connectionRemoved(wrapper);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    @Override
    public boolean canCreate() {
        return true;
    }

    @Override
    public boolean canDelete(IConnectionWrapper wrapper) {
        return wrapper instanceof DefaultConnectionWrapper;
    }

    @Override
    public IConnectionWrapper createConnection(Map map) throws CoreException {
        String id = (String)map.get(ID);
        String url = (String)map.get(URL);
        String username = (String)map.get(USERNAME);
        String password = (String)map.get(PASSWORD);
        MBeanServerConnectionDescriptor desc = new MBeanServerConnectionDescriptor(id, url, username, password);
        try {
            return new DefaultConnectionWrapper(desc);
        }
        catch (MalformedURLException murle) {
            throw new CoreException((IStatus)new Status(4, "com.fusesource.ide.jmx.core", murle.getLocalizedMessage(), (Throwable)murle));
        }
    }

    @Override
    public IConnectionWrapper[] getConnections() {
        if (this.connections == null) {
            this.loadConnections();
        }
        return this.connections.values().toArray(new IConnectionWrapper[this.connections.values().size()]);
    }

    @Override
    public void addConnection(IConnectionWrapper connection) {
        if (connection instanceof DefaultConnectionWrapper) {
            MBeanServerConnectionDescriptor descriptor = ((DefaultConnectionWrapper)connection).getDescriptor();
            this.connections.put(descriptor.getID(), (DefaultConnectionWrapper)connection);
            try {
                this.save();
                this.fireAdded(connection);
            }
            catch (IOException ioe) {
                Status s = new Status(4, "com.fusesource.ide.jmx.core", JMXCoreMessages.DefaultConnection_ErrorAdding, (Throwable)ioe);
                JMXActivator.log((IStatus)s);
            }
        }
    }

    @Override
    public void removeConnection(IConnectionWrapper connection) {
        if (connection != null && connection.isConnected()) {
            try {
                connection.disconnect();
            }
            catch (Exception ioex) {
                Status s = new Status(4, "com.fusesource.ide.jmx.core", JMXCoreMessages.DefaultConnection_ErrorRemoving, (Throwable)ioex);
                JMXActivator.log((IStatus)s);
            }
        }
        if (connection instanceof DefaultConnectionWrapper) {
            MBeanServerConnectionDescriptor descriptor = ((DefaultConnectionWrapper)connection).getDescriptor();
            if (descriptor != null) {
                this.connections.remove(descriptor.getID());
            }
            try {
                this.save();
                this.fireRemoved(connection);
            }
            catch (IOException ioe) {
                Status s = new Status(4, "com.fusesource.ide.jmx.core", JMXCoreMessages.DefaultConnection_ErrorRemoving, (Throwable)ioe);
                JMXActivator.log((IStatus)s);
            }
        }
    }

    protected void loadConnections() {
        String filename = JMXActivator.getDefault().getStateLocation().append(STORE_FILE).toOSString();
        HashMap<String, DefaultConnectionWrapper> map = new HashMap<String, DefaultConnectionWrapper>();
        if (new File(filename).exists()) {
            try {
                IMemento root = XMLMemento.loadMemento(filename);
                IMemento[] child = root.getChildren(CONNECTION);
                int i = 0;
                while (i < child.length) {
                    String id = child[i].getString(ID);
                    String url = child[i].getString(URL);
                    String username = child[i].getString(USERNAME);
                    String password = child[i].getString(PASSWORD);
                    MBeanServerConnectionDescriptor desc = new MBeanServerConnectionDescriptor(id, url, username, password);
                    try {
                        DefaultConnectionWrapper connection = new DefaultConnectionWrapper(desc);
                        map.put(id, connection);
                    }
                    catch (MalformedURLException malformedURLException) {}
                    ++i;
                }
                this.connections = map;
            }
            catch (IOException ioe) {
                Status s = new Status(4, "com.fusesource.ide.jmx.core", JMXCoreMessages.DefaultConnection_ErrorLoading, (Throwable)ioe);
                JMXActivator.log((IStatus)s);
            }
        } else {
            this.connections = map;
        }
    }

    protected void save() throws IOException {
        String filename = JMXActivator.getDefault().getStateLocation().append(STORE_FILE).toOSString();
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.connections.keySet());
        Collections.sort(keys);
        XMLMemento root = XMLMemento.createWriteRoot(CONNECTIONS);
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            MBeanServerConnectionDescriptor descriptor;
            DefaultConnectionWrapper wrapper = this.connections.get(i.next());
            if (wrapper == null || (descriptor = wrapper.getDescriptor()) == null) continue;
            IMemento child = root.createChild(CONNECTION);
            child.putString(ID, descriptor.getID());
            child.putString(URL, descriptor.getURL());
            child.putString(USERNAME, descriptor.getUserName());
            child.putString(PASSWORD, descriptor.getPassword());
        }
        root.saveToFile(filename);
    }

    @Override
    public String getName(IConnectionWrapper wrapper) {
        MBeanServerConnectionDescriptor desc;
        if (wrapper instanceof DefaultConnectionWrapper && (desc = ((DefaultConnectionWrapper)wrapper).getDescriptor()) != null) {
            return desc.getID();
        }
        return null;
    }
}

