/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.core.providers;

import com.fusesource.ide.jmx.core.ExtensionManager;
import com.fusesource.ide.jmx.core.IConnectionProvider;
import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.ide.jmx.core.IJMXRunnable;
import com.fusesource.ide.jmx.core.JMXCoreMessages;
import com.fusesource.ide.jmx.core.JMXException;
import com.fusesource.ide.jmx.core.providers.DefaultConnectionProvider;
import com.fusesource.ide.jmx.core.providers.MBeanServerConnectionDescriptor;
import com.fusesource.ide.jmx.core.tree.NodeUtils;
import com.fusesource.ide.jmx.core.tree.Root;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DefaultConnectionWrapper
implements IConnectionWrapper {
    private JMXServiceURL url;
    private JMXConnector connector;
    private MBeanServerConnection connection;
    private Root root;
    private boolean isConnected = false;
    private Map<String, String[]> environment = new HashMap<String, String[]>();
    private MBeanServerConnectionDescriptor descriptor;

    public DefaultConnectionWrapper(JMXServiceURL url) {
        this.url = url;
    }

    public DefaultConnectionWrapper(MBeanServerConnectionDescriptor descriptor) throws MalformedURLException {
        this.descriptor = descriptor;
        String username = descriptor.getUserName();
        if (username != null && username.length() > 0) {
            String[] credentials = new String[]{username, descriptor.getPassword()};
            this.environment.put("jmx.remote.credentials", credentials);
        }
        this.url = new JMXServiceURL(descriptor.getURL());
    }

    @Override
    public JMXConnector getConnector() {
        return this.connector;
    }

    public MBeanServerConnectionDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public IConnectionProvider getProvider() {
        return ExtensionManager.getProvider("com.fusesource.ide.jmx.core.providers.DefaultConnectionProvider");
    }

    public MBeanServerConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean canControl() {
        return true;
    }

    @Override
    public synchronized void connect() throws Exception {
        this.connector = JMXConnectorFactory.connect(this.url, this.environment);
        this.connection = this.connector.getMBeanServerConnection();
        this.isConnected = true;
        this.fireConnectionChanged();
    }

    @Override
    public synchronized void disconnect() throws Exception {
        this.root = null;
        this.isConnected = false;
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            finally {
                this.fireConnectionChanged();
            }
        } else {
            this.fireConnectionChanged();
        }
        this.connector = null;
        this.connection = null;
    }

    protected void fireConnectionChanged() {
        ((DefaultConnectionProvider)this.getProvider()).fireChanged(this);
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public Root getRoot() {
        return this.root;
    }

    @Override
    public void loadRoot() {
        if (this.isConnected() && this.root == null) {
            try {
                this.root = NodeUtils.createObjectNameTree(this);
            }
            catch (CoreException coreException) {}
        }
    }

    @Override
    public void run(IJMXRunnable runnable) throws CoreException {
        try {
            runnable.run(this.getConnection());
        }
        catch (JMXException ce) {
            Status s = new Status(4, "com.fusesource.ide.jmx.core", JMXCoreMessages.DefaultConnection_ErrorRunningJMXCode, (Throwable)ce);
            throw new CoreException((IStatus)s);
        }
    }
}

