/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.core.tree;

import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.ide.jmx.core.IJMXRunnable;
import com.fusesource.ide.jmx.core.JMXActivator;
import com.fusesource.ide.jmx.core.JMXException;
import com.fusesource.ide.jmx.core.tree.MBeansNode;
import com.fusesource.ide.jmx.core.tree.NodeBuilder;
import com.fusesource.ide.jmx.core.tree.NodeProvider;
import com.fusesource.ide.jmx.core.tree.ObjectNameNode;
import com.fusesource.ide.jmx.core.tree.PropertyNode;
import com.fusesource.ide.jmx.core.tree.Root;
import com.fusesource.rider.commons.tree.Node;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class NodeUtils {
    public static PropertyNode findObjectNameNode(Node node, ObjectName objectName) {
        ObjectNameNode onNode;
        Assert.isNotNull((Object)node);
        if (node instanceof ObjectNameNode && (onNode = (ObjectNameNode)node).getObjectName().equals(objectName)) {
            return onNode;
        }
        Node[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            Node child = children[i];
            PropertyNode found = NodeUtils.findObjectNameNode(child, objectName);
            if (found != null) {
                return found;
            }
            ++i;
        }
        return null;
    }

    public static Root createObjectNameTree(final IConnectionWrapper connectionWrapper) throws CoreException {
        final Root[] _root = new Root[1];
        connectionWrapper.run(new IJMXRunnable(){

            @Override
            public void run(MBeanServerConnection connection) throws JMXException {
                try {
                    Root rootNode;
                    Set<ObjectName> beanInfo = connection.queryNames(new ObjectName("*:*"), null);
                    _root[0] = rootNode = NodeBuilder.createRoot(connectionWrapper);
                    MBeansNode mbeans = rootNode.getMBeansNode();
                    rootNode.addChild((Node)mbeans);
                    for (ObjectName on : beanInfo) {
                        NodeBuilder.addToTree((Node)mbeans, on);
                    }
                }
                catch (IOException iOException) {
                }
                catch (MalformedObjectNameException malformedObjectNameException) {}
            }
        });
        Root root = _root[0];
        if (root != null) {
            NodeUtils.enrichRootNode(root);
        }
        return root;
    }

    protected static void enrichRootNode(Root root) {
        List<NodeProvider> providers = JMXActivator.getNodeProviders();
        for (NodeProvider provider : providers) {
            provider.provide(root);
        }
    }
}

