/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.core.tree;

import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.ide.jmx.core.JMXActivator;
import com.fusesource.ide.jmx.core.tree.DomainNode;
import com.fusesource.ide.jmx.core.tree.MBeansNode;
import com.fusesource.rider.commons.tree.HasRefreshableUI;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.Refreshable;
import com.fusesource.rider.commons.tree.RefreshableUI;
import com.fusesource.rider.commons.ui.drop.DelegateDropListener;
import com.fusesource.rider.commons.ui.drop.DropHandler;
import com.fusesource.rider.commons.ui.drop.DropHandlerFactory;
import java.util.List;
import org.eclipse.swt.dnd.DropTargetEvent;

public class Root
extends Node
implements Refreshable,
DropHandlerFactory {
    private IConnectionWrapper connection;
    private MBeansNode mbeansNode;

    public Root(IConnectionWrapper connection) {
        super(null);
        this.connection = connection;
        this.mbeansNode = new MBeansNode(this);
        this.addChild((Node)this.mbeansNode);
    }

    public String toString() {
        return "Root";
    }

    public int compareTo(Object o) {
        return 0;
    }

    public IConnectionWrapper getConnection() {
        return this.connection;
    }

    public boolean containsDomain(String domain) {
        return this.getDomainNode(domain) != null;
    }

    public DomainNode getDomainNode(String domain) {
        Node[] nodes;
        Node[] nodeArray = nodes = this.mbeansNode.getChildren();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            DomainNode domainNode;
            Node node = nodeArray[n2];
            if (node instanceof DomainNode && domain.equals((domainNode = (DomainNode)node).getDomain())) {
                return domainNode;
            }
            ++n2;
        }
        return null;
    }

    public void refresh() {
        IConnectionWrapper wrapper = this.connection;
        if (wrapper != null) {
            try {
                wrapper.disconnect();
                wrapper.connect();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected RefreshableUI getRefreshableUI() {
        if (this.connection instanceof HasRefreshableUI) {
            HasRefreshableUI ui = (HasRefreshableUI)this.connection;
            return ui.getRefreshableUI();
        }
        return super.getRefreshableUI();
    }

    public DropHandler createDropHandler(DropTargetEvent event) {
        List children = this.getChildrenList();
        for (Node node : children) {
            DropHandler handler = DelegateDropListener.createDropHandler((Object)node, (DropTargetEvent)event);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    public static Root getRoot(Node parent) {
        if (parent.getParent() == null) {
            return (Root)parent;
        }
        return Root.getRoot(parent.getParent());
    }

    public MBeansNode getMBeansNode() {
        return this.mbeansNode;
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    public void connect() {
        if (this.connection != null) {
            try {
                this.connection.connect();
            }
            catch (Exception e) {
                JMXActivator.getLogger().warning("Failed to connect to " + this.connection + ". " + e, (Throwable)e);
            }
        }
    }
}

