/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.branding.wizards;

import com.fusesource.rider.branding.Activator;
import com.fusesource.rider.branding.wizards.WizardMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewMessageWizardPage
extends WizardPage {
    protected static final String DEFAULT_CAMEL_XML_NAME = "message.xml";
    private Text containerText;
    private Text fileText;
    private ISelection selection;

    public NewMessageWizardPage(ISelection selection) {
        super(WizardMessages.NewMessageWizardPage_pageTitle);
        this.setTitle(WizardMessages.NewMessageWizardPage_pageTitle);
        this.setDescription(WizardMessages.NewMessageWizardPage_description);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&RouteContainer:");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "com.fusesource.rider.editor.newFuseMessage");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMessageWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(WizardMessages.NewMessageWizardPage_browseButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewMessageWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(WizardMessages.NewMessageWizardPage_labelFile);
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMessageWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IJavaElement) {
                IJavaElement element = (IJavaElement)obj;
                try {
                    obj = element.getUnderlyingResource();
                }
                catch (JavaModelException e) {
                    Activator.getLogger().error("Failed to examine IJavaElement: " + (Object)((Object)e), (Throwable)e);
                }
            }
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            } else {
                Activator.getLogger().warning("Selection is not a resource so can't select it for the container: " + obj + " " + obj.getClass().getCanonicalName());
            }
        }
        this.fileText.setText(DEFAULT_CAMEL_XML_NAME);
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, WizardMessages.NewMessageWizardPage_containerSelectionLabel);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus(WizardMessages.NewMessageWizardPage_statusUnspecifiedContainer);
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus(WizardMessages.NewMessageWizardPage_statusContainerNotExisting);
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(WizardMessages.NewMessageWizardPage_statusProjectReadOnly);
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(WizardMessages.NewMessageWizardPage_statusUnspecifiedFileName);
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus(WizardMessages.NewMessageWizardPage_statusInvalidFileName);
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("xml")) {
            this.updateStatus(WizardMessages.NewMessageWizardPage_statusInvalidExtension);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }
}

