/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.branding.wizards.project;

import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.commons.util.Strings;
import java.net.URL;
import org.fusesource.camel.rider.util.Archetype;

public class ArchetypeDetails
implements Comparable<ArchetypeDetails> {
    private final Archetype archetype;
    private String groupId;
    private String artifactId;
    private String version;
    private String description;
    private String repository;
    private URL resource;
    private String fullName;

    public ArchetypeDetails(Archetype archetype) {
        this.archetype = archetype;
        this.groupId = archetype.groupId();
        this.artifactId = archetype.artifactId();
        this.version = archetype.version();
        this.description = archetype.description();
        this.fullName = String.valueOf(this.artifactId) + "-" + this.version + ".jar";
    }

    public boolean contains(String currentFilter) {
        return Strings.contains((String)currentFilter, (String[])new String[]{this.groupId, this.artifactId, this.version});
    }

    @Override
    public int compareTo(ArchetypeDetails that) {
        int answer = Objects.compare((Object)this.groupId, (Object)that.groupId);
        if (answer == 0 && (answer = Objects.compare((Object)this.artifactId, (Object)that.artifactId)) == 0) {
            answer = Objects.compare((Object)this.version, (Object)that.version);
        }
        return answer;
    }

    public Archetype getArchetype() {
        return this.archetype;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public URL getResource() {
        return this.resource;
    }

    public void setResource(URL resource) {
        this.resource = resource;
    }

    public String getFullName() {
        return this.fullName;
    }
}

