/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.branding.wizards.project;

import com.fusesource.rider.branding.Activator;
import com.fusesource.rider.branding.wizards.WizardMessages;
import com.fusesource.rider.branding.wizards.project.AbstractCreateProjectJob;
import com.fusesource.rider.branding.wizards.project.AbstractFuseProjectWizard;
import com.fusesource.rider.branding.wizards.project.ArchetypeDetails;
import com.fusesource.rider.branding.wizards.project.FuseProjectWizardArchetypePage;
import com.fusesource.rider.branding.wizards.project.FuseProjectWizardLocationPage;
import com.fusesource.rider.branding.wizards.project.SelectionUtil;
import com.fusesource.rider.editor.wizard.NewFuseProjectHelper;
import com.fusesource.rider.maven.MavenFacade;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;

public class FuseProjectWizard
extends AbstractFuseProjectWizard
implements INewWizard {
    protected FuseProjectWizardLocationPage locationPage;
    private FuseProjectWizardArchetypePage archetypePage;

    public FuseProjectWizard() {
        this.setWindowTitle(WizardMessages.wizardProjectTitle);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/new_fuse_project_wizard.png"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.locationPage = new FuseProjectWizardLocationPage(WizardMessages.wizardProjectPageProjectTitle, WizardMessages.wizardProjectPageProjectDescription, this.workingSets){

            @Override
            protected void createAdditionalControls(Composite container) {
                Label label = new Label(container, 0);
                GridData labelData = new GridData(4, 128, false, false, 3, 1);
                labelData.heightHint = 10;
                label.setLayoutData((Object)labelData);
            }

            public IWizardPage getNextPage() {
                return FuseProjectWizard.this.getPage("MavenProjectWizardArchetypePage");
            }
        };
        this.locationPage.setLocationPath(SelectionUtil.getSelectedLocation(this.selection));
        this.archetypePage = new FuseProjectWizardArchetypePage();
        this.addPage((IWizardPage)this.locationPage);
        this.addPage((IWizardPage)this.archetypePage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public boolean performFinish() {
        final String projectName = this.archetypePage.getProjectName();
        IStatus nameStatus = this.archetypePage.validateProjectName();
        if (!nameStatus.isOK()) {
            MessageDialog.openError((Shell)this.getShell(), (String)NLS.bind((String)WizardMessages.wizardProjectJobFailed, (Object)projectName), (String)nameStatus.getMessage());
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = this.locationPage.isInWorkspace() ? null : this.locationPage.getLocationPath();
        final IWorkspaceRoot root = workspace.getRoot();
        final IPath rootPath = this.locationPage.isInWorkspace() ? root.getLocation().append(projectName) : location;
        final File pomFile = rootPath.append("pom.xml").toFile();
        boolean pomExists = pomFile.exists();
        if (pomExists) {
            MessageDialog.openError((Shell)this.getShell(), (String)NLS.bind((String)WizardMessages.wizardProjectJobFailed, (Object)projectName), (String)WizardMessages.wizardProjectErrorPomAlreadyExists);
            return false;
        }
        final String groupId = this.archetypePage.getGroupId();
        final String artifactId = this.archetypePage.getArtifactId();
        final String version = this.archetypePage.getVersion();
        final ArchetypeDetails archetype = this.archetypePage.getArchetype();
        final String javaPackage = this.archetypePage.getJavaPackage();
        this.archetypePage.getProperties();
        Activator.getLogger().debug("About to create project: " + projectName + " from archetype: " + archetype + " for " + groupId + ": " + artifactId + ":" + version + " at " + rootPath);
        final NewFuseProjectHelper helper = new NewFuseProjectHelper();
        String jobName = NLS.bind((String)WizardMessages.wizardProjectJobCreating, (Object)projectName);
        AbstractCreateProjectJob job = new AbstractCreateProjectJob(jobName, this.workingSets){

            @Override
            protected List<IProject> doCreateMavenProjects(IProgressMonitor monitor) throws CoreException {
                try {
                    URL resource = archetype.getResource();
                    InputStream in = resource.openStream();
                    File outputDir = rootPath.toFile();
                    helper.createProject(in, outputDir, groupId, artifactId, version, javaPackage);
                    IProject project = root.getProject(projectName);
                    MavenFacade facade = new MavenFacade();
                    facade.importProjects(monitor, pomFile, projectName, groupId, artifactId, version);
                    return Arrays.asList(project);
                }
                catch (IOException e) {
                    Status status = new Status(4, "com.fusesource.rider.plugin.wizards", 0, NLS.bind((String)WizardMessages.failedToOpenArchetype, (Object)e.getMessage()), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                final IStatus result = event.getResult();
                if (!result.isOK()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)FuseProjectWizard.this.getShell(), (String)NLS.bind((String)WizardMessages.wizardProjectJobFailed, (Object)projectName), (String)result.getMessage());
                        }
                    });
                }
            }
        });
        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
        job.setRule(rule);
        job.schedule();
        return true;
    }
}

