/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.branding.wizards.project;

import com.fusesource.rider.branding.Activator;
import com.fusesource.rider.branding.wizards.WizardMessages;
import com.fusesource.rider.branding.wizards.project.AbstractFuseWizardPage;
import com.fusesource.rider.branding.wizards.project.ArchetypeDetails;
import com.fusesource.rider.commons.Viewers;
import com.fusesource.rider.commons.util.Strings;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.fusesource.camel.rider.util.Archetype;
import org.fusesource.camel.rider.util.Archetypes;
import org.osgi.framework.Bundle;

public class FuseProjectWizardArchetypePage
extends AbstractFuseWizardPage {
    ComboViewer catalogsComboViewer;
    Text filterText;
    TableViewer viewer;
    Text descriptionText;
    private boolean isUsed = true;
    volatile Collection<ArchetypeDetails> archetypes;
    public static final String DEFAULT_VERSION = "1.0.0-SNAPSHOT";
    public static final String DEFAULT_PACKAGE = "foo";
    Table propertiesTable;
    TableViewer propertiesViewer;
    public static final String KEY_PROPERTY = "key";
    public static final int KEY_INDEX = 0;
    public static final String VALUE_PROPERTY = "value";
    public static final int VALUE_INDEX = 1;
    protected Combo groupIdCombo;
    protected Combo artifactIdCombo;
    protected Combo versionCombo;
    protected Combo packageCombo;
    protected Button removeButton;
    protected Set<String> requiredProperties;
    protected Set<String> optionalProperties;
    protected ArchetypeDetails archetype;
    protected boolean archetypeChanged = false;
    protected boolean packageCustomized = false;
    private boolean defaultFocusOnFilter = true;
    private boolean userChangedArtifactId = false;

    public FuseProjectWizardArchetypePage() {
        super("MavenProjectWizardArchetypePage");
        this.setTitle(WizardMessages.wizardProjectPageArchetypeTitle);
        this.setDescription(WizardMessages.wizardProjectPageArchetypeDescription);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.fusesource.rider.editor.newFuseProjectArchetype");
        this.createViewer(composite);
        this.setControl((Control)composite);
    }

    private void createViewer(Composite parent) {
        Label filterLabel = new Label(parent, 0);
        filterLabel.setLayoutData((Object)new GridData());
        filterLabel.setText(WizardMessages.MavenProjectWizardArchetypePage_lblFilter);
        QuickViewerFilter quickViewerFilter = new QuickViewerFilter();
        this.filterText = new Text(parent, 2176);
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.filterText.addModifyListener((ModifyListener)quickViewerFilter);
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    FuseProjectWizardArchetypePage.this.viewer.getTable().setFocus();
                    FuseProjectWizardArchetypePage.this.viewer.getTable().setSelection(0);
                    FuseProjectWizardArchetypePage.this.viewer.setSelection((ISelection)new StructuredSelection(FuseProjectWizardArchetypePage.this.viewer.getElementAt(0)), true);
                }
            }
        });
        ToolBar toolBar = new ToolBar(parent, 0x800000);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        final ToolItem clearToolItem = new ToolItem(toolBar, 8);
        clearToolItem.setEnabled(false);
        clearToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuseProjectWizardArchetypePage.this.filterText.setText("");
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                clearToolItem.setEnabled(FuseProjectWizardArchetypePage.this.filterText.getText().length() > 0);
            }
        });
        SashForm sashForm = new SashForm(parent, 512);
        GridData gd_sashForm = new GridData(4, 4, false, true, 3, 1);
        gd_sashForm.heightHint = 200;
        sashForm.setLayoutData((Object)gd_sashForm);
        sashForm.setLayout((Layout)new GridLayout());
        Composite composite1 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.horizontalSpacing = 0;
        gridLayout1.marginWidth = 0;
        gridLayout1.marginHeight = 0;
        composite1.setLayout((Layout)gridLayout1);
        this.viewer = new TableViewer(composite1, 68356);
        Table table = this.viewer.getTable();
        table.setData("name", (Object)"archetypesTable");
        table.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setWidth(200);
        column1.setText(WizardMessages.wizardProjectPageArchetypeColumnGroupId);
        TableColumn column0 = new TableColumn(table, 16384);
        column0.setWidth(200);
        column0.setText(WizardMessages.wizardProjectPageArchetypeColumnArtifactId);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setWidth(150);
        column2.setText(WizardMessages.wizardProjectPageArchetypeColumnVersion);
        GridData tableData = new GridData(4, 4, true, true);
        tableData.widthHint = 600;
        tableData.heightHint = 200;
        table.setLayoutData((Object)tableData);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ArchetypeLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((ArchetypeDetails)e1).compareTo((ArchetypeDetails)e2);
            }
        });
        this.viewer.addFilter((ViewerFilter)quickViewerFilter);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (FuseProjectWizardArchetypePage.this.descriptionText == null) {
                    return;
                }
                ArchetypeDetails archetype = FuseProjectWizardArchetypePage.this.getArchetype();
                if (archetype != null) {
                    String repositoryUrl = archetype.getRepository();
                    String description = archetype.getDescription();
                    String text = description == null ? "" : description;
                    text = text.replaceAll("\n", "").replaceAll("\\s{2,}", " ");
                    if (repositoryUrl != null) {
                        text = String.valueOf(text) + (text.length() > 0 ? "\n" + repositoryUrl : repositoryUrl);
                    }
                    FuseProjectWizardArchetypePage.this.descriptionText.setText(text);
                    if (FuseProjectWizardArchetypePage.this.artifactIdCombo != null && (Strings.isBlank((String)FuseProjectWizardArchetypePage.this.getArtifactId()) || !FuseProjectWizardArchetypePage.this.userChangedArtifactId)) {
                        String value = archetype.getArtifactId().replace("archetype-", "");
                        FuseProjectWizardArchetypePage.this.artifactIdCombo.setText(value);
                        FuseProjectWizardArchetypePage.this.userChangedArtifactId = false;
                    }
                } else {
                    FuseProjectWizardArchetypePage.this.descriptionText.setText("");
                }
                FuseProjectWizardArchetypePage.this.validate();
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openevent) {
                if (FuseProjectWizardArchetypePage.this.canFlipToNextPage()) {
                    FuseProjectWizardArchetypePage.this.getContainer().showPage(FuseProjectWizardArchetypePage.this.getNextPage());
                }
            }
        });
        List<ArchetypeDetails> list = this.getArchetypes();
        this.viewer.setInput(list);
        Composite composite2 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout2);
        this.descriptionText = new Text(composite2, 526922);
        this.descriptionText.setEnabled(false);
        this.descriptionText.setEditable(false);
        GridData descriptionTextData = new GridData(4, 4, true, true);
        descriptionTextData.heightHint = 40;
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        descriptionTextData.widthHint = 250;
        sashForm.setWeights(new int[]{80, 20});
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createArtifactGroup(composite);
        Composite buttonComposite = new Composite(parent, 0);
        GridData gd_buttonComposite = new GridData(4, 0x1000000, false, false, 3, 1);
        buttonComposite.setLayoutData((Object)gd_buttonComposite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        buttonComposite.setLayout((Layout)gridLayout);
        if (!list.isEmpty()) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)list.get(0)));
            Viewers.async((Runnable)new Runnable(){

                @Override
                public void run() {
                    FuseProjectWizardArchetypePage.this.userChangedArtifactId = false;
                }
            });
        }
        if (Strings.isBlank((String)this.getGroupId())) {
            int itemCount = this.groupIdCombo.getItemCount();
            String groupId = "com.mycompany";
            if (itemCount > 0) {
                groupId = this.groupIdCombo.getItem(0);
            }
            this.groupIdCombo.setText(groupId);
        }
    }

    private void createArtifactGroup(Composite parent) {
        Label groupIdlabel = new Label(parent, 0);
        groupIdlabel.setText(WizardMessages.artifactComponentGroupId);
        this.groupIdCombo = new Combo(parent, 2048);
        this.groupIdCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.addFieldWithHistory("groupId", this.groupIdCombo);
        this.groupIdCombo.setData("name", (Object)"groupId");
        this.groupIdCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FuseProjectWizardArchetypePage.this.updateJavaPackage();
                FuseProjectWizardArchetypePage.this.validate();
            }
        });
        Label artifactIdLabel = new Label(parent, 0);
        artifactIdLabel.setText(WizardMessages.artifactComponentArtifactId);
        this.artifactIdCombo = new Combo(parent, 2048);
        this.artifactIdCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.addFieldWithHistory("artifactId", this.artifactIdCombo);
        this.artifactIdCombo.setData("name", (Object)"artifactId");
        this.artifactIdCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FuseProjectWizardArchetypePage.this.updateJavaPackage();
                FuseProjectWizardArchetypePage.this.validate();
                FuseProjectWizardArchetypePage.this.userChangedArtifactId = true;
            }
        });
        Label versionLabel = new Label(parent, 0);
        versionLabel.setText(WizardMessages.artifactComponentVersion);
        this.versionCombo = new Combo(parent, 2048);
        GridData gd_versionCombo = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_versionCombo.widthHint = 150;
        this.versionCombo.setLayoutData((Object)gd_versionCombo);
        this.versionCombo.setText(DEFAULT_VERSION);
        this.addFieldWithHistory("version", this.versionCombo);
        this.versionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FuseProjectWizardArchetypePage.this.validate();
            }
        });
        Label packageLabel = new Label(parent, 0);
        packageLabel.setText(WizardMessages.artifactComponentPackage);
        this.packageCombo = new Combo(parent, 2048);
        this.packageCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.packageCombo.setData("name", (Object)"package");
        this.addFieldWithHistory("package", this.packageCombo);
        this.packageCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String current = FuseProjectWizardArchetypePage.this.packageCombo.getText();
                String defaultPackage = FuseProjectWizardArchetypePage.this.getDefaultJavaPackage();
                if (!(FuseProjectWizardArchetypePage.this.packageCustomized || current.equals("") || FuseProjectWizardArchetypePage.this.packageCombo.getText().equals(defaultPackage))) {
                    FuseProjectWizardArchetypePage.this.packageCustomized = true;
                }
                FuseProjectWizardArchetypePage.this.validate();
            }
        });
    }

    protected IWizardContainer getContainer() {
        return super.getContainer();
    }

    public void addArchetypeSelectionListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public List<ArchetypeDetails> getArchetypes() {
        try {
            ArrayList<ArchetypeDetails> answer = new ArrayList<ArchetypeDetails>();
            Bundle bundle = Activator.getDefault().getBundle();
            if (bundle != null) {
                URL xml = bundle.getResource("/archetypes/archetypes.xml");
                Object object = null;
                try {
                    Unmarshaller unmarshaller = Archetypes.newUnmarshaller();
                    object = unmarshaller.unmarshal(xml);
                }
                catch (Exception e) {
                    Activator.getLogger().warning((Throwable)e);
                }
                if (object instanceof Archetypes) {
                    Archetypes archetypesDTO = (Archetypes)object;
                    List list = archetypesDTO.archetypes();
                    for (Archetype archetype : list) {
                        ArchetypeDetails details = new ArchetypeDetails(archetype);
                        URL resource = bundle.getResource("/archetypes/" + details.getFullName());
                        details.setResource(resource);
                        answer.add(details);
                    }
                }
            }
            return answer;
        }
        catch (Exception exception) {
            this.setErrorMessage(WizardMessages.MavenProjectWizardArchetypePage_error_read);
            return null;
        }
    }

    public void setUsed(boolean isUsed) {
        this.isUsed = isUsed;
    }

    public boolean isPageComplete() {
        String error = this.validateInput();
        return super.isPageComplete() && error == null && this.getArchetype() != null;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.defaultFocusOnFilter) {
                this.filterText.setFocus();
            } else {
                this.viewer.getTable().setFocus();
            }
            ArchetypeDetails selected = this.getArchetype();
            if (selected != null) {
                this.viewer.reveal((Object)selected);
            }
            System.out.println("================= Setting visible");
            this.userChangedArtifactId = false;
        }
    }

    public ArchetypeDetails getArchetype() {
        return (ArchetypeDetails)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
    }

    protected void reloadViewer() {
    }

    void validate() {
        String error = this.validateInput();
        ArchetypeDetails a = this.getArchetype();
        if (a != null || error == null) {
            this.setErrorMessage(error);
        }
        this.setPageComplete(error == null);
    }

    private String validateInput() {
        String error = this.validateGroupIdInput(this.groupIdCombo.getText().trim());
        if (error != null) {
            return error;
        }
        error = this.validateArtifactIdInput(this.artifactIdCombo.getText().trim());
        if (error != null) {
            return error;
        }
        String versionValue = this.versionCombo.getText().trim();
        if (versionValue.length() == 0) {
            return WizardMessages.wizardProjectPageMaven2ValidatorVersion;
        }
        String packageName = this.packageCombo.getText();
        if (packageName.trim().length() != 0 && !Pattern.matches("[A-Za-z_$][A-Za-z_$\\d]*(?:\\.[A-Za-z_$][A-Za-z_$\\d]*)*", packageName)) {
            return WizardMessages.MavenProjectWizardArchetypeParametersPage_error_package;
        }
        IStatus nameStatus = this.validateProjectName();
        if (!nameStatus.isOK()) {
            return NLS.bind((String)WizardMessages.wizardProjectPageMaven2ValidatorProjectNameInvalid, (Object)nameStatus.getMessage());
        }
        if (this.requiredProperties != null && this.requiredProperties.size() > 0) {
            Properties properties = this.getProperties();
            for (String key : this.requiredProperties) {
                String value = properties.getProperty(key);
                if (value != null && value.length() != 0) continue;
                return NLS.bind((String)WizardMessages.wizardProjectPageMaven2ValidatorRequiredProperty, (Object)key);
            }
        }
        return null;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        if (this.propertiesViewer != null && this.propertiesViewer.isCellEditorActive()) {
            this.propertiesTable.setFocus();
        }
        if (this.propertiesTable != null) {
            int i = 0;
            while (i < this.propertiesTable.getItemCount()) {
                TableItem item = this.propertiesTable.getItem(i);
                properties.put(item.getText(0), item.getText(1));
                ++i;
            }
        }
        return properties;
    }

    protected void updateJavaPackage() {
        if (this.packageCustomized) {
            return;
        }
        String defaultPackageName = this.getDefaultJavaPackage();
        this.packageCombo.setText(defaultPackageName);
    }

    protected String getDefaultJavaPackage() {
        return FuseProjectWizardArchetypePage.getDefaultJavaPackage(this.groupIdCombo.getText().trim(), this.artifactIdCombo.getText().trim());
    }

    public String getJavaPackage() {
        if (this.packageCombo.getText().length() > 0) {
            return this.packageCombo.getText();
        }
        return this.getDefaultJavaPackage();
    }

    public static String getDefaultJavaPackage(String groupId, String artifactId) {
        StringBuffer sb = new StringBuffer(groupId);
        if (sb.length() > 0 && artifactId.length() > 0) {
            sb.append('.');
        }
        sb.append(artifactId);
        if (sb.length() == 0) {
            sb.append(DEFAULT_PACKAGE);
        }
        boolean isFirst = true;
        StringBuffer pkg = new StringBuffer();
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (c == '-') {
                pkg.append('.');
                isFirst = false;
            } else if (isFirst) {
                if (Character.isJavaIdentifierStart(c)) {
                    pkg.append(c);
                    isFirst = false;
                }
            } else if (c == '.') {
                pkg.append('.');
                isFirst = true;
            } else if (Character.isJavaIdentifierPart(c)) {
                pkg.append(c);
            }
            ++i;
        }
        return pkg.toString();
    }

    public String getGroupId() {
        return this.groupIdCombo.getText();
    }

    public String getArtifactId() {
        return this.artifactIdCombo.getText();
    }

    public String getVersion() {
        return this.versionCombo.getText();
    }

    public String getProjectName() {
        return this.getArtifactId();
    }

    public IStatus validateProjectName() {
        String projectName = this.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(projectName, 4);
        if (!nameStatus.isOK()) {
            return nameStatus;
        }
        if (workspace.getRoot().getProject(projectName).exists()) {
            return new Status(4, "com.fusesource.rider.plugin.wizards", 0, NLS.bind((String)WizardMessages.importProjectExists, (Object)projectName), null);
        }
        return Status.OK_STATUS;
    }

    protected static class ArchetypeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected ArchetypeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ArchetypeDetails) {
                ArchetypeDetails archetype = (ArchetypeDetails)element;
                switch (columnIndex) {
                    case 0: {
                        return archetype.getGroupId();
                    }
                    case 1: {
                        return archetype.getArtifactId();
                    }
                    case 2: {
                        return archetype.getVersion();
                    }
                }
            }
            return super.getText(element);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    protected class QuickViewerFilter
    extends ViewerFilter
    implements ModifyListener {
        private String currentFilter;

        protected QuickViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.currentFilter == null || this.currentFilter.length() == 0) {
                return true;
            }
            ArchetypeDetails archetype = (ArchetypeDetails)element;
            return archetype.contains(this.currentFilter);
        }

        public void modifyText(ModifyEvent e) {
            this.currentFilter = FuseProjectWizardArchetypePage.this.filterText.getText().trim();
            FuseProjectWizardArchetypePage.this.viewer.refresh();
        }
    }
}

