/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.branding.wizards.project;

import com.fusesource.rider.branding.wizards.WizardMessages;
import com.fusesource.rider.branding.wizards.project.AbstractFuseWizardPage;
import com.fusesource.rider.branding.wizards.project.WorkingSetGroup;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;

public class FuseProjectWizardLocationPage
extends AbstractFuseWizardPage {
    Button useDefaultWorkspaceLocationButton;
    Label locationLabel;
    Combo locationCombo;
    boolean initialized = false;
    private WorkingSetGroup workingSetGroup;
    private IPath location;
    private final List<IWorkingSet> workingSets;

    public FuseProjectWizardLocationPage(String title, String description, List<IWorkingSet> workingSets) {
        super("MavenProjectWizardLocationPage");
        this.workingSets = workingSets;
        this.setTitle(title);
        this.setDescription(description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        this.createAdditionalControls(container);
        this.useDefaultWorkspaceLocationButton = new Button(container, 32);
        GridData useDefaultWorkspaceLocationButtonData = new GridData(16384, 0x1000000, false, false, 3, 1);
        this.useDefaultWorkspaceLocationButton.setLayoutData((Object)useDefaultWorkspaceLocationButtonData);
        this.useDefaultWorkspaceLocationButton.setText(WizardMessages.MavenProjectWizardLocationPage_btnUserDefault);
        this.useDefaultWorkspaceLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean inWorkspace = FuseProjectWizardLocationPage.this.isInWorkspace();
                FuseProjectWizardLocationPage.this.locationLabel.setEnabled(!inWorkspace);
                FuseProjectWizardLocationPage.this.locationCombo.setEnabled(!inWorkspace);
            }
        });
        this.useDefaultWorkspaceLocationButton.setSelection(true);
        this.locationLabel = new Label(container, 0);
        GridData locationLabelData = new GridData();
        locationLabelData.horizontalIndent = 10;
        this.locationLabel.setLayoutData((Object)locationLabelData);
        this.locationLabel.setText(WizardMessages.MavenProjectWizardLocationPage_lblLocation);
        this.locationLabel.setEnabled(false);
        this.locationCombo = new Combo(container, 0);
        GridData locationComboData = new GridData(4, 0x1000000, true, false);
        this.locationCombo.setLayoutData((Object)locationComboData);
        this.locationCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FuseProjectWizardLocationPage.this.validate();
            }
        });
        this.locationCombo.setEnabled(false);
        this.addFieldWithHistory("location", this.locationCombo);
        Button locationBrowseButton = new Button(container, 0);
        GridData locationBrowseButtonData = new GridData(4, 0x1000000, false, false);
        locationBrowseButton.setLayoutData((Object)locationBrowseButtonData);
        locationBrowseButton.setText(WizardMessages.MavenProjectWizardLocationPage_btnLocation);
        locationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(FuseProjectWizardLocationPage.this.getShell());
                dialog.setText(WizardMessages.MavenProjectWizardLocationPage_dialog_location);
                String path = FuseProjectWizardLocationPage.this.locationCombo.getText();
                if (path.length() == 0) {
                    path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toPortableString();
                }
                dialog.setFilterPath(path);
                String selectedDir = dialog.open();
                if (selectedDir != null) {
                    FuseProjectWizardLocationPage.this.locationCombo.setText(selectedDir);
                    FuseProjectWizardLocationPage.this.useDefaultWorkspaceLocationButton.setSelection(false);
                    FuseProjectWizardLocationPage.this.validate();
                }
            }
        });
        this.workingSetGroup = new WorkingSetGroup(container, this.workingSets, this.getShell());
        if (this.location != null && !Platform.getLocation().equals((Object)this.location)) {
            this.locationCombo.setText(this.location.toOSString());
        }
        this.setControl((Control)container);
    }

    protected void createAdditionalControls(Composite container) {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.workingSetGroup.dispose();
    }

    public boolean isInWorkspace() {
        return this.useDefaultWorkspaceLocationButton.getSelection();
    }

    public IPath getLocationPath() {
        if (this.isInWorkspace()) {
            return ResourcesPlugin.getWorkspace().getRoot().getLocation();
        }
        return Path.fromOSString((String)this.locationCombo.getText().trim());
    }

    public void setLocationPath(IPath location) {
        this.location = location;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initialized = true;
            this.validate();
        }
    }

    protected void validate() {
        if (!this.initialized) {
            return;
        }
        ResourcesPlugin.getWorkspace();
        IPath projectPath = this.getLocationPath();
        String location = projectPath.toOSString();
        if (location.length() == 0) {
            this.setErrorMessage(null);
            this.setMessage(WizardMessages.wizardProjectPageProjectValidatorProjectLocation);
            this.setPageComplete(false);
            return;
        }
        if (!Path.ROOT.isValidPath(location)) {
            this.setErrorMessage(WizardMessages.wizardProjectPageProjectValidatorInvalidLocation);
            this.setPageComplete(false);
            return;
        }
        this.isInWorkspace();
        this.setPageComplete(true);
        this.setErrorMessage(null);
        this.setMessage(null);
    }
}

