/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IDesignEngine;
import org.eclipse.birt.report.model.api.IDesignEngineFactory;
import org.eclipse.birt.report.model.api.IModuleOption;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.metadata.IMetaDataDictionary;
import org.eclipse.birt.report.model.api.metadata.IMetaLogger;
import org.eclipse.birt.report.model.api.simpleapi.IReportDesign;

public final class DesignEngine
implements IDesignEngine {
    protected static final Logger errorLogger = Logger.getLogger(DesignEngine.class.getName());
    protected static IDesignEngineFactory cachedFactory;
    protected IDesignEngine engine;

    public DesignEngine(DesignConfig config) {
        Object factory;
        try {
            Platform.startup((PlatformConfig)config);
        }
        catch (BirtException e) {
            errorLogger.log(Level.SEVERE, "Error occurs while start the platform", e);
        }
        if (cachedFactory == null && (factory = Platform.createFactoryObject((String)"org.eclipse.birt.report.model.DesignEngineFactory")) instanceof IDesignEngineFactory) {
            cachedFactory = (IDesignEngineFactory)factory;
        }
        if (cachedFactory != null) {
            this.engine = cachedFactory.createDesignEngine(config);
        }
        if (this.engine == null) {
            errorLogger.log(Level.INFO, "Can not start the design engine.");
        }
    }

    public SessionHandle newSessionHandle(ULocale locale) {
        return this.engine.newSessionHandle(locale);
    }

    public static SessionHandle newSession(ULocale locale) {
        return new DesignEngine(new DesignConfig()).newSessionHandle(locale);
    }

    public IMetaDataDictionary getMetaData() {
        return this.engine.getMetaData();
    }

    public static IMetaDataDictionary getMetaDataDictionary() {
        return new DesignEngine(new DesignConfig()).getMetaData();
    }

    public void registerMetaLogger(IMetaLogger newLogger) {
        this.engine.registerMetaLogger(newLogger);
    }

    public boolean removeMetaLogger(IMetaLogger logger) {
        return this.engine.removeMetaLogger(logger);
    }

    public IReportDesign openDesign(String fileName, InputStream ins, IModuleOption options) throws DesignFileException {
        return this.engine.openDesign(fileName, ins, options);
    }
}

