/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.data;

import com.fusesource.zk.jmx.data.IObjectNamePart;
import com.fusesource.zk.jmx.data.ObjectNameKeyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

public final class Domain
implements IObjectNamePart {
    private List<ObjectNameKeyValue> _ChildObjectNameKeyValues;
    private final ObjectName _DomainPatternObjectName;
    private Map<ObjectName, ObjectNameKeyValue> _MBeanObjectNameKeyValueMap;
    private Set<ObjectName> _MBeanObjectNames;
    private final String _Name;
    private Map<String, ObjectNameKeyValue> _ObjectNameKeyValueMap;

    Domain(String name, ObjectName domainPatternObjectName) {
        this._Name = name;
        this._DomainPatternObjectName = domainPatternObjectName;
    }

    @Override
    public List<ObjectNameKeyValue> getChildObjectNameKeyValues() {
        if (this._ChildObjectNameKeyValues == null) {
            this.initChildObjectNameParts();
        }
        return this._ChildObjectNameKeyValues;
    }

    public ObjectName getDomainPatternObjectName() {
        return this._DomainPatternObjectName;
    }

    public ObjectNameKeyValue getMBeanObjectNameKeyValue(ObjectName mbeanObjectName) {
        if (this._MBeanObjectNameKeyValueMap == null) {
            this.initChildObjectNameParts();
        }
        return this._MBeanObjectNameKeyValueMap.get(mbeanObjectName);
    }

    public Set<ObjectName> getMBeanObjectNames() {
        return this._MBeanObjectNames;
    }

    public String getName() {
        return this._Name;
    }

    public ObjectNameKeyValue getObjectNameKeyValue(String keyValuePairString) {
        if (this._ObjectNameKeyValueMap == null) {
            this.initChildObjectNameParts();
        }
        return this._ObjectNameKeyValueMap.get(keyValuePairString);
    }

    @Override
    public String getObjectNamePartString() {
        return this.getName();
    }

    @Override
    public IObjectNamePart getParentObjectNamePart() {
        return null;
    }

    public void setMBeanObjectNames(Set<ObjectName> mBeanObjectNames) {
        this._MBeanObjectNames = mBeanObjectNames;
        this._ChildObjectNameKeyValues = null;
        this._ObjectNameKeyValueMap = null;
        this._MBeanObjectNameKeyValueMap = null;
    }

    public String toString() {
        return "Domain [" + (this._Name != null ? "Name=" + this._Name : "") + "]";
    }

    private void initChildObjectNameParts() {
        this._ChildObjectNameKeyValues = new ArrayList<ObjectNameKeyValue>();
        this._ObjectNameKeyValueMap = new HashMap<String, ObjectNameKeyValue>();
        this._MBeanObjectNameKeyValueMap = new HashMap<ObjectName, ObjectNameKeyValue>();
        if (this._MBeanObjectNames == null) {
            return;
        }
        for (ObjectName objectName : this._MBeanObjectNames) {
            ObjectNameKeyValue parentObjectNameKeyValue = null;
            String keyPropertyListString = objectName.getKeyPropertyListString();
            String[] keyValuePairStrings = keyPropertyListString.split(",");
            int keyValuePairCount = keyValuePairStrings.length;
            int i = 0;
            while (i < keyValuePairCount) {
                String keyValuePairString = keyValuePairStrings[i];
                String[] keyValuePair = keyValuePairString.split("=");
                String key = keyValuePair[0];
                if (this._ObjectNameKeyValueMap.containsKey(keyValuePairString)) {
                    parentObjectNameKeyValue = this._ObjectNameKeyValueMap.get(keyValuePairString);
                } else {
                    boolean isMBean = false;
                    if (i == keyValuePairCount - 1) {
                        isMBean = true;
                    }
                    IObjectNamePart parentObjectNamePart = this;
                    List<ObjectNameKeyValue> childParts = this._ChildObjectNameKeyValues;
                    if (parentObjectNameKeyValue != null) {
                        parentObjectNamePart = parentObjectNameKeyValue;
                        childParts = parentObjectNameKeyValue.getChildObjectNameKeyValues();
                    }
                    ObjectNameKeyValue objectNameKeyValue = new ObjectNameKeyValue(objectName, isMBean, key, parentObjectNamePart);
                    childParts.add(objectNameKeyValue);
                    this._ObjectNameKeyValueMap.put(keyValuePairString, objectNameKeyValue);
                    if (isMBean) {
                        this._MBeanObjectNameKeyValueMap.put(objectName, objectNameKeyValue);
                    }
                    parentObjectNameKeyValue = objectNameKeyValue;
                }
                ++i;
            }
        }
    }
}

