/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.data;

import com.fusesource.zk.jmx.data.Domain;
import com.fusesource.zk.jmx.data.IJmxConnectionEventListener;
import com.fusesource.zk.jmx.data.JmxConnectionDescriptor;
import com.fusesource.zk.jmx.data.JmxConnectionEvent;
import com.fusesource.zk.jmx.data.MBean;
import com.fusesource.zk.jmx.data.MBeanAttribute;
import com.fusesource.zk.jmx.data.MBeanOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JmxConnection {
    private final JmxConnectionDescriptor _Descriptor;
    private CopyOnWriteArrayList<IJmxConnectionEventListener> _EventListeners;
    private JMXConnector _JMXConnector;
    private MBeanServerConnection _MBeanServerConnection;
    private MBeanServerDelegateNotificationListener _MBeanServerDelegateNotificationListener;
    private ConnectionNotificationListener _ConnectionNotificationListener;
    private boolean _Connected;

    public JmxConnection(JmxConnectionDescriptor descriptor) {
        this._Descriptor = descriptor;
    }

    public void addEventListener(IJmxConnectionEventListener listener) {
        if (this._EventListeners == null) {
            this._EventListeners = new CopyOnWriteArrayList();
        }
        if (!this._EventListeners.contains(listener)) {
            this._EventListeners.add(listener);
        }
    }

    public void close() {
        if (this._JMXConnector == null) {
            return;
        }
        try {
            this._JMXConnector.close();
        }
        catch (IOException iOException) {}
        this._Connected = false;
        this.removeConnectionListener();
        this.removeMBeanServerDelegateListener();
        this._JMXConnector = null;
        this._MBeanServerConnection = null;
        this.fireConnectionStateChanged(null);
    }

    public void connect() {
        this.close();
        JmxConnectionDescriptor descriptor = this.getDescriptor();
        JMXServiceURL jmxUrl = descriptor.getJmxServiceUrl();
        String userName = descriptor.getUserName();
        String password = descriptor.getPassword();
        HashMap<String, String[]> env = null;
        if (userName != null) {
            env = new HashMap<String, String[]>();
            env.put("jmx.remote.credentials", new String[]{userName, password});
        }
        try {
            this._JMXConnector = JMXConnectorFactory.connect(jmxUrl, env);
            this._MBeanServerConnection = this._JMXConnector.getMBeanServerConnection();
            this._Connected = true;
            this.addConnectionListener();
            this.addMBeanServerDelegateListener();
            this.fireConnectionStateChanged(null);
        }
        catch (IOException iOException) {}
    }

    public Domain getDefaultDomain() {
        if (!this.isConnected()) {
            return null;
        }
        String defaultDomainName = this.getDefaultDomainName();
        return this.getDomain(defaultDomainName);
    }

    public String getDefaultDomainName() {
        if (!this.isConnected()) {
            return null;
        }
        String defaultDomainName = null;
        try {
            defaultDomainName = this._MBeanServerConnection.getDefaultDomain();
        }
        catch (IOException iOException) {}
        return defaultDomainName;
    }

    public JmxConnectionDescriptor getDescriptor() {
        return this._Descriptor;
    }

    public Domain getDomain(String domainName) {
        if (domainName == null) {
            throw new IllegalArgumentException("null domain name");
        }
        ObjectName domainPatternObjectName = null;
        try {
            domainPatternObjectName = new ObjectName(String.valueOf(domainName) + ":*");
        }
        catch (Throwable throwable) {
            return null;
        }
        if (domainPatternObjectName == null) {
            return null;
        }
        Set<ObjectName> mbeanObjectNames = this.getObjectNames(domainPatternObjectName);
        Domain domain = new Domain(domainName, domainPatternObjectName);
        domain.setMBeanObjectNames(mbeanObjectNames);
        return domain;
    }

    public Set<String> getDomainNames() {
        if (!this.isConnected()) {
            return Collections.emptySet();
        }
        String[] domainNames = null;
        try {
            domainNames = this._MBeanServerConnection.getDomains();
        }
        catch (IOException iOException) {
            return null;
        }
        return new TreeSet<String>(Arrays.asList(domainNames));
    }

    public List<Domain> getDomains() {
        Set<String> domainNames = this.getDomainNames();
        if (domainNames == null) {
            return null;
        }
        ArrayList<Domain> domainList = new ArrayList<Domain>(domainNames.size());
        for (String domainName : domainNames) {
            Domain domain = this.getDomain(domainName);
            if (domain == null) continue;
            domainList.add(domain);
        }
        return domainList;
    }

    public JMXConnector getJMXConnector() {
        return this._JMXConnector;
    }

    public MBean getMBean(ObjectName objectName) {
        if (objectName == null) {
            throw new IllegalArgumentException("null ObjectName");
        }
        List<MBean> mbeans = this.getMBeans(objectName);
        if (mbeans.size() == 0) {
            return null;
        }
        if (mbeans.size() > 1) {
            throw new IllegalArgumentException("ObjectName: " + objectName + " matched more than one MBean");
        }
        return mbeans.get(0);
    }

    public MBeanAttribute getMBeanAttribute(MBean mbean, String attributeName) {
        if (mbean == null) {
            throw new IllegalArgumentException("null MBean");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("null attributeName");
        }
        MBeanAttributeInfo attributeInfo = mbean.getAttributeInfo(attributeName);
        MBeanAttribute mbeanAttribute = new MBeanAttribute(attributeName);
        mbeanAttribute.setInfo(attributeInfo);
        Object value = null;
        try {
            value = this._MBeanServerConnection.getAttribute(mbean.getObjectName(), attributeName);
        }
        catch (Throwable t) {
            String errorMessage = t.getLocalizedMessage();
            mbeanAttribute.setValueRetrievalErrorMessage(errorMessage);
        }
        mbeanAttribute.setValue(value);
        return mbeanAttribute;
    }

    public List<MBeanAttribute> getMBeanAttributes(MBean mbean) {
        if (mbean == null) {
            throw new IllegalArgumentException("null MBean");
        }
        if (!this.isConnected()) {
            return Collections.emptyList();
        }
        MBeanInfo mbeanInfo = mbean.getInfo();
        MBeanAttributeInfo[] attributeInfos = mbeanInfo.getAttributes();
        if (attributeInfos == null) {
            return null;
        }
        String[] attributeNames = new String[attributeInfos.length];
        HashMap<String, MBeanAttribute> mbeanAttributeMap = new HashMap<String, MBeanAttribute>(attributeInfos.length);
        int i = 0;
        while (i < attributeInfos.length) {
            MBeanAttributeInfo attributeInfo = attributeInfos[i];
            String attributeName = attributeInfo.getName();
            MBeanAttribute mbeanAttribute = new MBeanAttribute(attributeName);
            mbeanAttribute.setInfo(attributeInfo);
            mbeanAttributeMap.put(attributeName, mbeanAttribute);
            attributeNames[i] = attributeName;
            ++i;
        }
        AttributeList attributes = null;
        try {
            attributes = this._MBeanServerConnection.getAttributes(mbean.getObjectName(), attributeNames);
        }
        catch (Exception exception) {
            return null;
        }
        if (attributes == null) {
            return null;
        }
        List<Attribute> attributeList = attributes.asList();
        ArrayList<MBeanAttribute> mbeanAttributeList = new ArrayList<MBeanAttribute>(attributeList.size());
        for (Attribute attribute : attributeList) {
            String attributeName = attribute.getName();
            MBeanAttribute mbeanAttribute = (MBeanAttribute)mbeanAttributeMap.get(attributeName);
            if (mbeanAttribute == null) continue;
            mbeanAttribute.setValue(attribute.getValue());
            mbeanAttributeList.add(mbeanAttribute);
        }
        return mbeanAttributeList;
    }

    public MBeanOperation getMBeanOperation(MBean mbean, String operationName) {
        if (mbean == null) {
            throw new IllegalArgumentException("null MBean");
        }
        if (operationName == null) {
            throw new IllegalArgumentException("null operationName");
        }
        MBeanOperationInfo operationInfo = mbean.getOperationInfo(operationName);
        MBeanOperation mbeanOperation = new MBeanOperation(operationName);
        mbeanOperation.setInfo(operationInfo);
        return mbeanOperation;
    }

    public List<MBeanOperation> getMBeanOperations(MBean mbean) {
        if (mbean == null) {
            throw new IllegalArgumentException("null MBean");
        }
        Set<String> operationNames = mbean.getOperationNames();
        ArrayList<MBeanOperation> mbeanOperations = new ArrayList<MBeanOperation>(operationNames.size());
        for (String operationName : operationNames) {
            MBeanOperation mbeanOperation = this.getMBeanOperation(mbean, operationName);
            mbeanOperations.add(mbeanOperation);
        }
        return mbeanOperations;
    }

    public List<MBean> getMBeans() {
        return this.getMBeans(null, null);
    }

    public List<MBean> getMBeans(ObjectName objectNamePattern) {
        return this.getMBeans(objectNamePattern, null);
    }

    public List<MBean> getMBeans(ObjectName objectNamePattern, QueryExp queryExp) {
        Set<ObjectName> objectNames = this.getObjectNames(objectNamePattern, queryExp);
        return this.getMBeans(objectNames);
    }

    public List<MBean> getMBeans(Set<ObjectName> objectNames) {
        if (objectNames == null) {
            return null;
        }
        if (!this.isConnected()) {
            return Collections.emptyList();
        }
        ArrayList<MBean> mbeanList = new ArrayList<MBean>(objectNames.size());
        for (ObjectName objectName : objectNames) {
            MBeanInfo mbeanInfo = null;
            try {
                mbeanInfo = this._MBeanServerConnection.getMBeanInfo(objectName);
            }
            catch (Exception exception) {}
            if (mbeanInfo == null) continue;
            MBean mbean = new MBean(objectName);
            mbean.setInfo(mbeanInfo);
            mbeanList.add(mbean);
        }
        return mbeanList;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this._MBeanServerConnection;
    }

    public Set<ObjectName> getObjectNames() {
        return this.getObjectNames(null);
    }

    public Set<ObjectName> getObjectNames(ObjectName objectNamePattern) {
        return this.getObjectNames(objectNamePattern, null);
    }

    public Set<ObjectName> getObjectNames(ObjectName objectNamePattern, QueryExp queryExp) {
        if (!this.isConnected()) {
            return Collections.emptySet();
        }
        Set<ObjectName> objectNameSet = null;
        try {
            objectNameSet = this._MBeanServerConnection.queryNames(objectNamePattern, queryExp);
        }
        catch (Exception exception) {
            return null;
        }
        return new TreeSet<ObjectName>(objectNameSet);
    }

    public Object invokeMBeanOperation(MBean mbean, MBeanOperation mbeanOperation, Object[] params) {
        if (mbean == null) {
            throw new IllegalArgumentException("null MBean");
        }
        if (mbeanOperation == null) {
            throw new IllegalArgumentException("null operation");
        }
        String[] signature = null;
        if (params != null) {
            signature = mbeanOperation.getInvocationSignature();
        }
        if (!this.isConnected()) {
            return null;
        }
        Object result = null;
        try {
            result = this._MBeanServerConnection.invoke(mbean.getObjectName(), mbeanOperation.getName(), params, signature);
        }
        catch (Throwable throwable) {}
        return result;
    }

    public boolean isConnected() {
        return this._Connected;
    }

    public void removeEventListener(IJmxConnectionEventListener listener) {
        if (this._EventListeners == null) {
            return;
        }
        if (!this._EventListeners.contains(listener)) {
            return;
        }
        this._EventListeners.remove(listener);
    }

    public String toString() {
        return "JmxConnection [" + (this._Descriptor != null ? "Descriptor=" + (Object)((Object)this._Descriptor) : "") + "]";
    }

    private void addConnectionListener() {
        this._ConnectionNotificationListener = new ConnectionNotificationListener();
        this._JMXConnector.addConnectionNotificationListener(this._ConnectionNotificationListener, null, this);
    }

    private void addMBeanServerDelegateListener() {
        this._MBeanServerDelegateNotificationListener = new MBeanServerDelegateNotificationListener();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("JMX.mbean.registered");
        filter.enableType("JMX.mbean.unregistered");
        try {
            this._MBeanServerConnection.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this._MBeanServerDelegateNotificationListener, (NotificationFilter)filter, null);
        }
        catch (Exception exception) {}
    }

    private void fireMBeanRegistered(ObjectName objectName) {
        if (this._EventListeners != null) {
            JmxConnectionEvent event = new JmxConnectionEvent(this, objectName);
            for (IJmxConnectionEventListener listener : this._EventListeners) {
                listener.mbeanRegistered(event);
            }
        }
    }

    private void fireMBeanUnregistered(ObjectName objectName) {
        if (this._EventListeners != null) {
            JmxConnectionEvent event = new JmxConnectionEvent(this, objectName);
            for (IJmxConnectionEventListener listener : this._EventListeners) {
                listener.mbeanUnregistered(event);
            }
        }
    }

    private void fireConnectionStateChanged(JMXConnectionNotification notification) {
        if (this._EventListeners != null) {
            JmxConnectionEvent event = new JmxConnectionEvent(this, notification);
            for (IJmxConnectionEventListener listener : this._EventListeners) {
                listener.connectionStateChanged(event);
            }
        }
    }

    private void removeConnectionListener() {
        if (this._JMXConnector == null || this._ConnectionNotificationListener == null) {
            return;
        }
        try {
            this._JMXConnector.removeConnectionNotificationListener(this._ConnectionNotificationListener);
        }
        catch (Exception exception) {}
    }

    private void removeMBeanServerDelegateListener() {
        if (this._MBeanServerConnection == null || this._MBeanServerDelegateNotificationListener == null) {
            return;
        }
        try {
            this._MBeanServerConnection.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this._MBeanServerDelegateNotificationListener);
        }
        catch (Exception exception) {}
    }

    private class ConnectionNotificationListener
    implements NotificationListener {
        private ConnectionNotificationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (handback != JmxConnection.this || !(notification instanceof JMXConnectionNotification)) {
                return;
            }
            JMXConnectionNotification jmxConnectionNotification = (JMXConnectionNotification)notification;
            JmxConnection.this._Connected = "jmx.remote.connection.opened".equals(jmxConnectionNotification.getType());
            JmxConnection.this.fireConnectionStateChanged(jmxConnectionNotification);
        }
    }

    private class MBeanServerDelegateNotificationListener
    implements NotificationListener {
        private MBeanServerDelegateNotificationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification instanceof MBeanServerNotification) {
                MBeanServerNotification mbeanNotification = (MBeanServerNotification)notification;
                String notificationType = mbeanNotification.getType();
                ObjectName objectName = mbeanNotification.getMBeanName();
                if (notificationType.equals("JMX.mbean.registered")) {
                    JmxConnection.this.fireMBeanRegistered(objectName);
                } else if (notificationType.equals("JMX.mbean.unregistered")) {
                    JmxConnection.this.fireMBeanUnregistered(objectName);
                }
            }
        }
    }
}

