/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.data;

import com.fusesource.zk.jmx.data.JmxUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public final class MBean {
    private Map<String, MBeanAttributeInfo> _AttributeInfoMap;
    private Set<String> _AttributeNames;
    private MBeanInfo _Info;
    private final ObjectName _ObjectName;
    private Map<String, MBeanOperationInfo> _OperationInfoMap;
    private Set<String> _OperationNames;

    MBean(ObjectName objectName) {
        this._ObjectName = objectName;
    }

    public MBeanAttributeInfo getAttributeInfo(String attributeName) {
        if (this._AttributeInfoMap == null) {
            this.initAttributeCollections();
        }
        return this._AttributeInfoMap.get(attributeName);
    }

    public Set<String> getAttributeNames() {
        if (this._AttributeNames == null) {
            this.initAttributeCollections();
        }
        return this._AttributeNames;
    }

    public MBeanInfo getInfo() {
        return this._Info;
    }

    public ObjectName getObjectName() {
        return this._ObjectName;
    }

    public MBeanOperationInfo getOperationInfo(String operationName) {
        if (this._OperationInfoMap == null) {
            this.initOperationCollections();
        }
        return this._OperationInfoMap.get(operationName);
    }

    public Set<String> getOperationNames() {
        if (this._OperationNames == null) {
            this.initOperationCollections();
        }
        return this._OperationNames;
    }

    public void setInfo(MBeanInfo info) {
        this._Info = info;
        this._AttributeNames = null;
        this._AttributeInfoMap = null;
    }

    public String toString() {
        return "MBean [" + (this._ObjectName != null ? "ObjectName=" + this._ObjectName : "") + "]";
    }

    private void initAttributeCollections() {
        MBeanAttributeInfo[] attributeInfos = this._Info.getAttributes();
        int size = 0;
        if (attributeInfos != null) {
            size = attributeInfos.length;
        }
        this._AttributeNames = new TreeSet<String>();
        this._AttributeInfoMap = new HashMap<String, MBeanAttributeInfo>(size);
        if (size == 0) {
            return;
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray = attributeInfos;
        int n = attributeInfos.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanAttributeInfo attributeInfo = mBeanAttributeInfoArray[n2];
            String attributeName = attributeInfo.getName();
            this._AttributeNames.add(attributeName);
            this._AttributeInfoMap.put(attributeName, attributeInfo);
            ++n2;
        }
    }

    private void initOperationCollections() {
        MBeanOperationInfo[] operationInfos = this._Info.getOperations();
        int size = 0;
        if (operationInfos != null) {
            size = operationInfos.length;
        }
        this._OperationNames = new TreeSet<String>();
        this._OperationInfoMap = new HashMap<String, MBeanOperationInfo>(size);
        if (size == 0) {
            return;
        }
        MBeanOperationInfo[] mBeanOperationInfoArray = operationInfos;
        int n = operationInfos.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanOperationInfo operationInfo = mBeanOperationInfoArray[n2];
            String operationName = JmxUtils.getOperationName(operationInfo);
            this._OperationNames.add(operationName);
            this._OperationInfoMap.put(operationName, operationInfo);
            ++n2;
        }
    }
}

