/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.data;

import com.fusesource.zk.jmx.data.IObjectNamePart;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;

public final class ObjectNameKeyValue
implements IObjectNamePart {
    private final List<ObjectNameKeyValue> _ChildObjectNameKeyValues;
    private final String _KeyValuePairString;
    private final boolean _MBean;
    private final ObjectName _ObjectName;
    private final String _ObjectNameKey;
    private final IObjectNamePart _ParentObjectNamePart;

    public ObjectNameKeyValue(ObjectName objectName, boolean isMBean, String objectNameKey, IObjectNamePart parentObjectNamePart) {
        this._ObjectName = objectName;
        this._MBean = isMBean;
        this._ObjectNameKey = objectNameKey;
        this._ParentObjectNamePart = parentObjectNamePart;
        this._ChildObjectNameKeyValues = new ArrayList<ObjectNameKeyValue>();
        this._KeyValuePairString = String.valueOf(objectNameKey) + "=" + this.getObjectNameValue();
    }

    @Override
    public List<ObjectNameKeyValue> getChildObjectNameKeyValues() {
        return this._ChildObjectNameKeyValues;
    }

    public String getKeyValuePairString() {
        return this._KeyValuePairString;
    }

    public ObjectName getObjectName() {
        return this._ObjectName;
    }

    public String getObjectNameKey() {
        return this._ObjectNameKey;
    }

    @Override
    public String getObjectNamePartString() {
        return this.getObjectNameValue();
    }

    public String getObjectNameValue() {
        return this.getObjectName().getKeyProperty(this.getObjectNameKey());
    }

    @Override
    public IObjectNamePart getParentObjectNamePart() {
        return this._ParentObjectNamePart;
    }

    public boolean isMBean() {
        return this._MBean;
    }

    public String toString() {
        return "ObjectNameKeyValue [" + (this._ObjectName != null ? "ObjectName=" + this._ObjectName + ", " : "") + (this._ObjectNameKey != null ? "ObjectNameKey=" + this._ObjectNameKey : "") + "]";
    }
}

