/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.editors;

import com.fusesource.zk.core.EclipseCoreActivator;
import com.fusesource.zk.core.editors.DataModelFormEditor;
import com.fusesource.zk.core.editors.DataModelFormPage;
import com.fusesource.zk.core.model.DataModel;
import javax.management.Descriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class BaseJmxModelMainFormPage<M extends DataModel<M, ?, ?>>
extends DataModelFormPage<M> {
    protected static final int[] DEFAULT_NAME_VALUE_COLUMN_ALIGNMENTS = new int[]{16384, 16384};
    protected static final String[] DEFAULT_NAME_VALUE_COLUMN_TITLES = new String[]{"Name", "Value"};
    protected static final int[] DEFAULT_NAME_VALUE_COLUMN_WIDTHS = new int[]{-1, 350};
    protected static final int DEFAULT_TABLE_STYLE = 66306;
    protected static final Image IMAGE = EclipseCoreActivator.getManagedImage((String)"IMAGE_KEY_OBJECT_MAIN_TAB");
    protected static final String TITLE = "Main";
    protected static final String DESCRIPTOR_SECTION_TITLE = "Descriptor";
    private Section _DetailSection;
    private Section _DescriptorSection;
    private String _DescriptorSectionTitle;
    private Section _InfoSection;
    private String _InfoSectionTitle;
    private Section _PrimarySection;
    private String _PrimarySectionTitle;

    public BaseJmxModelMainFormPage(DataModelFormEditor<M> editor, String id) {
        super(editor, id, TITLE);
        this.setImage(IMAGE);
        this.setDescriptorSectionTitle(DESCRIPTOR_SECTION_TITLE);
    }

    public String getDescriptorSectionTitle() {
        return this._DescriptorSectionTitle;
    }

    public String getInfoSectionTitle() {
        return this._InfoSectionTitle;
    }

    public String getPrimarySectionTitle() {
        return this._PrimarySectionTitle;
    }

    public void setDescriptorSectionTitle(String descriptorSectionTitle) {
        this._DescriptorSectionTitle = descriptorSectionTitle;
        if (this._DescriptorSection != null) {
            this._DescriptorSection.setText(this._DescriptorSectionTitle);
        }
    }

    public void setInfoSectionTitle(String infoSectionTitle) {
        this._InfoSectionTitle = infoSectionTitle;
        if (this._InfoSection != null) {
            this._InfoSection.setText(this._InfoSectionTitle);
        }
    }

    public void setPrimarySectionTitle(String primarySectionTitle) {
        this._PrimarySectionTitle = primarySectionTitle;
        if (this._PrimarySection != null) {
            this._PrimarySection.setText(this._PrimarySectionTitle);
        }
    }

    protected Layout createClientLayout() {
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.verticalSpacing = 20;
        gridLayout.marginWidth = 8;
        return gridLayout;
    }

    protected Section createDescriptorSection(ScrolledForm form, Composite client, FormToolkit toolkit) {
        Descriptor descriptor = this.getJmxDescriptor();
        if (descriptor == null || descriptor.getFieldNames().length == 0) {
            return null;
        }
        return this.createTableSection(form, client, toolkit, this.getDescriptorSectionTitle(), EclipseCoreActivator.getManagedImage((String)"IMAGE_KEY_OBJECT_PROPERTIES"));
    }

    protected Section createInfoSection(ScrolledForm form, Composite client, FormToolkit toolkit) {
        return this.createTableSection(form, client, toolkit, this.getInfoSectionTitle(), EclipseCoreActivator.getManagedImage((String)"IMAGE_KEY_OBJECT_INFORMATION"));
    }

    protected final void createModelFormContent(IManagedForm managedForm, Composite client) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        this._PrimarySection = this.createPrimarySection(form, client, toolkit);
        this._DetailSection = this.createDetailSection(form, client, toolkit);
        this._InfoSection = this.createInfoSection(form, client, toolkit);
        this._DescriptorSection = this.createDescriptorSection(form, client, toolkit);
        if (this._PrimarySection != null) {
            GridData primarySectionGridData = new GridData(768);
            this._PrimarySection.setLayoutData((Object)primarySectionGridData);
        }
        if (this._DetailSection != null) {
            GridData detailSectionGridData = new GridData(768);
            this._DetailSection.setLayoutData((Object)detailSectionGridData);
        }
        if (this._InfoSection != null) {
            Table infoSectionTable = this.getInfoTable();
            this.initTableEdit(infoSectionTable, null, 1);
            GridData infoSectionGridData = new GridData(1808);
            this._InfoSection.setLayoutData((Object)infoSectionGridData);
        }
        if (this._DescriptorSection != null) {
            Table descriptorSectionTable = this.getDescriptorTable();
            this.initTableEdit(descriptorSectionTable, null, 1);
            GridData descriptorSectionGridData = new GridData(1808);
            this._DescriptorSection.setLayoutData((Object)descriptorSectionGridData);
        }
    }

    protected Section createPrimarySection(ScrolledForm form, Composite client, FormToolkit toolkit) {
        return null;
    }

    protected Section createDetailSection(ScrolledForm form, Composite client, FormToolkit toolkit) {
        return null;
    }

    protected Section createTableSection(ScrolledForm form, Composite client, FormToolkit toolkit, String sectionTitle, Image image) {
        return this.createTableSection(form, client, toolkit, sectionTitle, image, 66306, DEFAULT_NAME_VALUE_COLUMN_TITLES, DEFAULT_NAME_VALUE_COLUMN_ALIGNMENTS);
    }

    protected final Section getDescriptorSection() {
        return this._DescriptorSection;
    }

    protected final Table getDescriptorTable() {
        if (this._DescriptorSection == null) {
            return null;
        }
        return (Table)this._DescriptorSection.getClient();
    }

    protected final Section getInfoSection() {
        return this._InfoSection;
    }

    protected final Table getInfoTable() {
        return (Table)this.getInfoSection().getClient();
    }

    protected final Section getPrimarySection() {
        return this._PrimarySection;
    }

    protected void initDescriptorSectionFromModel() {
        Descriptor descriptor = this.getJmxDescriptor();
        if (descriptor == null) {
            return;
        }
        Table table = this.getDescriptorTable();
        if (table == null) {
            return;
        }
        table.removeAll();
        String[] stringArray = descriptor.getFieldNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            TableItem item = new TableItem(table, 0);
            Object value = descriptor.getFieldValue(fieldName);
            item.setText(0, fieldName);
            item.setText(1, String.valueOf(value));
            ++n2;
        }
        this.packTable(table, DEFAULT_NAME_VALUE_COLUMN_WIDTHS);
    }

    protected abstract Descriptor getJmxDescriptor();

    protected void initFromModelInternal() {
        Section descriptionSection;
        Section infoSection;
        this.initPrimarySectionFromModel();
        this.initDetailSectionFromModel();
        this.initInfoSectionFromModel();
        this.packTable(this.getInfoTable(), DEFAULT_NAME_VALUE_COLUMN_WIDTHS);
        this.initDescriptorSectionFromModel();
        this.packTable(this.getDescriptorTable(), DEFAULT_NAME_VALUE_COLUMN_WIDTHS);
        Section primarySection = this.getPrimarySection();
        if (primarySection != null) {
            primarySection.layout(true);
        }
        if ((infoSection = this.getInfoSection()) != null) {
            infoSection.layout(true);
        }
        if ((descriptionSection = this.getDescriptorSection()) != null) {
            descriptionSection.layout(true);
        }
    }

    protected abstract void initDetailSectionFromModel();

    protected abstract void initInfoSectionFromModel();

    protected abstract void initPrimarySectionFromModel();
}

