/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.editors;

import com.fusesource.zk.core.editors.DataModelFormEditor;
import com.fusesource.zk.core.editors.DataModelFormPage;
import com.fusesource.zk.core.model.GenericDataModelEvent;
import com.fusesource.zk.jmx.JmxActivator;
import com.fusesource.zk.jmx.data.JmxConnection;
import com.fusesource.zk.jmx.data.JmxConnectionDescriptor;
import com.fusesource.zk.jmx.editors.JmxConnectionModelDomainsFormPage;
import com.fusesource.zk.jmx.editors.JmxConnectionModelMainFormPage;
import com.fusesource.zk.jmx.model.JmxConnectionModel;
import java.net.MalformedURLException;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;

public class JmxConnectionModelFormEditor
extends DataModelFormEditor<JmxConnectionModel> {
    public static final String ID = JmxConnectionModelFormEditor.class.getName();
    private JmxConnectionModelMainFormPage _MainPage;
    private JmxConnectionModelDomainsFormPage _DomainsPage;

    public void doSave(IProgressMonitor monitor) {
        JmxConnectionModel model = (JmxConnectionModel)this.getModel();
        if (model.isDestroyed()) {
            return;
        }
        JmxConnectionDescriptor descriptor = (JmxConnectionDescriptor)((Object)model.getKey());
        JMXServiceURL serviceUrl = descriptor.getJmxServiceUrl();
        String userName = descriptor.getUserName();
        String password = descriptor.getPassword();
        String errorMessageTitle = "Save Failed";
        if (this._MainPage.isDirty()) {
            try {
                serviceUrl = this._MainPage.getServiceUrl();
            }
            catch (MalformedURLException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)errorMessageTitle, (String)("Invalid Service URL value: " + e.getLocalizedMessage()));
                monitor.setCanceled(true);
                return;
            }
            userName = this._MainPage.getUserName();
            password = this._MainPage.getPassword();
        }
        try {
            if (this._MainPage.isDirty()) {
                descriptor.setJmxServiceUrl(serviceUrl);
                descriptor.setUserName(userName);
                descriptor.setPassword(password);
            }
            model.updateData();
            this.saveCompleted();
        }
        catch (Exception e) {
            JmxActivator.reportError(e);
            monitor.setCanceled(true);
        }
    }

    protected void addPages() {
        try {
            this._MainPage = new JmxConnectionModelMainFormPage(this);
            this.addPage(this._MainPage);
            this.updateDomainsPage();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    protected void modelDataChanged(GenericDataModelEvent event) {
        super.modelDataChanged(event);
        this.updateDomainsPage();
    }

    protected void modelDataRefreshed(GenericDataModelEvent event) {
        super.modelDataRefreshed(event);
        this.updateDomainsPage();
    }

    protected void modelDestroyed(GenericDataModelEvent event) {
        super.modelDestroyed(event);
        this.close(false);
    }

    private void updateDomainsPage() {
        if (((JmxConnection)((JmxConnectionModel)this.getModel()).getData()).isConnected()) {
            if (this._DomainsPage == null) {
                this._DomainsPage = new JmxConnectionModelDomainsFormPage(this);
                try {
                    this.addPage((DataModelFormPage)this._DomainsPage);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        } else if (this._DomainsPage != null && this.getPageCount() > 1) {
            this.removePage(1);
            this._DomainsPage.dispose();
            this._DomainsPage = null;
        }
    }
}

