/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.editors;

import com.fusesource.zk.core.EclipseCoreActivator;
import com.fusesource.zk.core.editors.DataModelFormEditor;
import com.fusesource.zk.core.editors.DataModelFormPage;
import com.fusesource.zk.jmx.data.JmxConnection;
import com.fusesource.zk.jmx.data.JmxConnectionDescriptor;
import com.fusesource.zk.jmx.editors.JmxConnectionModelFormEditor;
import com.fusesource.zk.jmx.model.JmxConnectionModel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public final class JmxConnectionModelMainFormPage
extends DataModelFormPage<JmxConnectionModel> {
    public static final String ID = JmxConnectionModelMainFormPage.class.getName();
    public static final Image IMAGE = EclipseCoreActivator.getManagedImage((String)"IMAGE_KEY_OBJECT_MAIN_TAB");
    public static final String TITLE = "Main";
    protected static final String PROPERTY_NAME_CONNECTION_ID = "Connection Id";
    protected static final String PROPERTY_NAME_MBEAN_COUNT = "MBean Count";
    protected static final String EDIT_SECTION_TITLE = "Edit";
    protected static final int[] PROPERTIES_COLUMN_ALIGNMENTS = new int[]{16384, 16384};
    protected static final String[] PROPERTIES_COLUMN_TITLES = new String[]{"Name", "Value"};
    protected static final int[] PROPERTIES_COLUMN_WIDTHS = new int[]{-1, 350};
    protected static final String PROPERTIES_SECTION_TITLE = "Properties";
    protected static final int PROPERTIES_TABLE_STYLE = 66306;
    private Section _EditSection;
    private Section _PropertiesSection;
    private Text _ServiceUrlText;
    private Text _UserNameText;
    private Text _PasswordText;

    public JmxConnectionModelMainFormPage(JmxConnectionModelFormEditor editor) {
        super((DataModelFormEditor)editor, ID, TITLE);
        this.setImage(IMAGE);
    }

    public JMXServiceURL getServiceUrl() throws MalformedURLException {
        String serviceUrl = this._ServiceUrlText.getText();
        serviceUrl = !serviceUrl.trim().isEmpty() ? serviceUrl : null;
        return new JMXServiceURL(serviceUrl);
    }

    public String getUserName() {
        String userName = this._UserNameText.getText();
        userName = !userName.trim().isEmpty() ? userName : null;
        return userName;
    }

    public String getPassword() {
        String password = this._PasswordText.getText();
        password = !password.trim().isEmpty() ? password : null;
        return password;
    }

    public Section getPropertiesSection() {
        return this._PropertiesSection;
    }

    protected Layout createClientLayout() {
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.verticalSpacing = 20;
        gridLayout.marginWidth = 8;
        return gridLayout;
    }

    protected void createModelFormContent(IManagedForm managedForm, Composite client) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        this._EditSection = this.createEditSection(form, client, toolkit);
        GridData editSectionGridData = new GridData(768);
        this._EditSection.setLayoutData((Object)editSectionGridData);
        this._PropertiesSection = this.createPropertiesTableSection(form, client, toolkit);
        GridData propertiesSectionGridData = new GridData(768);
        this._PropertiesSection.setLayoutData((Object)propertiesSectionGridData);
        Table propertiesSectionTable = this.getPropertiesSectionTable();
        this.initTableEdit(propertiesSectionTable, null, 1);
    }

    protected Section createEditSection(ScrolledForm form, Composite client, FormToolkit toolkit) {
        Section section = this.createSection(form, client, toolkit, EDIT_SECTION_TITLE, EclipseCoreActivator.getManagedImage((String)"IMAGE_KEY_OBJECT_EDIT"));
        Composite sectionClient = this.createSectionClient(section, toolkit);
        Label serviceUrlLabel = toolkit.createLabel(sectionClient, "&Service URL: ");
        this._ServiceUrlText = toolkit.createText(sectionClient, "", 2052);
        this._ServiceUrlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JmxConnectionModelMainFormPage.this.setDirtyInternal(true);
            }
        });
        Label userNameLabel = toolkit.createLabel(sectionClient, "&User Name: ");
        this._UserNameText = toolkit.createText(sectionClient, "", 2052);
        this._UserNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JmxConnectionModelMainFormPage.this.setDirtyInternal(true);
            }
        });
        Label passwordLabel = toolkit.createLabel(sectionClient, "&Password: ");
        this._PasswordText = toolkit.createText(sectionClient, "", 2052);
        this._PasswordText.setEchoChar('*');
        this._PasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JmxConnectionModelMainFormPage.this.setDirtyInternal(true);
            }
        });
        final Button showPasswordTextCheckBox = toolkit.createButton(sectionClient, "Show password &text", 32);
        showPasswordTextCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                char echoChar = showPasswordTextCheckBox.getSelection() ? (char)'\u0000' : '*';
                JmxConnectionModelMainFormPage.this._PasswordText.setEchoChar(echoChar);
            }
        });
        Label noteLabel = toolkit.createLabel(sectionClient, "NOTE:  Password will be stored unencrypted in a file", 16448);
        FormData serviceUrlLabelFormData = new FormData();
        serviceUrlLabelFormData.top = new FormAttachment((Control)this._ServiceUrlText, 0, 0x1000000);
        serviceUrlLabelFormData.left = new FormAttachment(0, 0);
        serviceUrlLabel.setLayoutData((Object)serviceUrlLabelFormData);
        FormData serviceUrlTextFormData = new FormData();
        serviceUrlTextFormData.top = new FormAttachment(0, 0);
        serviceUrlTextFormData.left = new FormAttachment((Control)serviceUrlLabel);
        serviceUrlTextFormData.right = new FormAttachment(100, 0);
        this._ServiceUrlText.setLayoutData((Object)serviceUrlTextFormData);
        FormData userNameLabelFormData = new FormData();
        userNameLabelFormData.top = new FormAttachment((Control)this._UserNameText, 0, 0x1000000);
        userNameLabelFormData.left = new FormAttachment(0, 0);
        userNameLabel.setLayoutData((Object)userNameLabelFormData);
        FormData userNameTextFormData = new FormData();
        userNameTextFormData.top = new FormAttachment((Control)this._ServiceUrlText);
        userNameTextFormData.left = new FormAttachment((Control)this._ServiceUrlText, 0, 16384);
        userNameTextFormData.right = new FormAttachment(100, 0);
        this._UserNameText.setLayoutData((Object)userNameTextFormData);
        FormData passwordLabelFormData = new FormData();
        passwordLabelFormData.top = new FormAttachment((Control)this._PasswordText, 0, 0x1000000);
        passwordLabelFormData.left = new FormAttachment(0, 0);
        passwordLabel.setLayoutData((Object)passwordLabelFormData);
        FormData passwordTextFormData = new FormData();
        passwordTextFormData.top = new FormAttachment((Control)this._UserNameText);
        passwordTextFormData.left = new FormAttachment((Control)this._ServiceUrlText, 0, 16384);
        passwordTextFormData.right = new FormAttachment(100, 0);
        this._PasswordText.setLayoutData((Object)passwordTextFormData);
        FormData showPasswordTextCheckBoxFormData = new FormData();
        showPasswordTextCheckBoxFormData.top = new FormAttachment((Control)this._PasswordText);
        showPasswordTextCheckBoxFormData.left = new FormAttachment(0, 0);
        showPasswordTextCheckBoxFormData.right = new FormAttachment(100, 0);
        showPasswordTextCheckBox.setLayoutData((Object)showPasswordTextCheckBoxFormData);
        FormData noteLabelFormData = new FormData();
        noteLabelFormData.top = new FormAttachment((Control)showPasswordTextCheckBox);
        noteLabelFormData.left = new FormAttachment(0, 0);
        noteLabelFormData.right = new FormAttachment(100, 0);
        noteLabel.setLayoutData((Object)noteLabelFormData);
        return section;
    }

    protected Section createPropertiesTableSection(ScrolledForm form, Composite client, FormToolkit toolkit) {
        return this.createTableSection(form, client, toolkit, PROPERTIES_SECTION_TITLE, EclipseCoreActivator.getManagedImage((String)"IMAGE_KEY_OBJECT_PROPERTIES"), 66306, PROPERTIES_COLUMN_TITLES, PROPERTIES_COLUMN_ALIGNMENTS);
    }

    protected final Table getPropertiesSectionTable() {
        return (Table)this.getPropertiesSection().getClient();
    }

    protected final void initFromModelInternal() {
        JmxConnectionModel model = (JmxConnectionModel)this.getModel();
        JmxConnectionDescriptor descriptor = (JmxConnectionDescriptor)((Object)model.getKey());
        String jmxServiceUrl = String.valueOf(descriptor.getJmxServiceUrl());
        this._ServiceUrlText.setText(jmxServiceUrl);
        String userName = descriptor.getUserName();
        userName = userName != null ? userName : "";
        this._UserNameText.setText(userName);
        if (userName != null) {
            String password = descriptor.getPassword();
            password = password != null ? password : "";
            this._PasswordText.setText(password);
        }
        this.initPropertiesSectionFromModel();
        Section propertiesSection = this.getPropertiesSection();
        if (propertiesSection != null) {
            propertiesSection.layout(true);
        }
    }

    protected void initPropertiesSectionFromModel() {
        Table table = this.getPropertiesSectionTable();
        table.removeAll();
        Map<String, String> properties = this.getZooKeeperConnectionProperties();
        for (String key : properties.keySet()) {
            TableItem item = new TableItem(table, 0);
            String value = properties.get(key);
            item.setText(0, key);
            item.setText(1, value);
        }
        this.packTable(table, PROPERTIES_COLUMN_WIDTHS);
    }

    private Map<String, String> getZooKeeperConnectionProperties() {
        JmxConnectionModel model = (JmxConnectionModel)this.getModel();
        JmxConnection connection = (JmxConnection)model.getData();
        if (!connection.isConnected()) {
            return Collections.emptyMap();
        }
        JMXConnector connector = connection.getJMXConnector();
        MBeanServerConnection mbeanServerConnection = connection.getMBeanServerConnection();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        try {
            this.putProperty(properties, PROPERTY_NAME_CONNECTION_ID, connector.getConnectionId());
        }
        catch (IOException iOException) {}
        try {
            this.putProperty(properties, PROPERTY_NAME_MBEAN_COUNT, mbeanServerConnection.getMBeanCount());
        }
        catch (IOException iOException) {}
        return properties;
    }

    private void putProperty(Map<String, String> properties, String key, Object value) {
        if (value == null) {
            value = "";
        }
        String stringValue = String.valueOf(value);
        properties.put(key, stringValue);
    }
}

