/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.editors;

import com.fusesource.zk.jmx.JmxActivator;
import com.fusesource.zk.jmx.data.MBeanAttribute;
import com.fusesource.zk.jmx.editors.MBeanAttributeModelFormEditor;
import com.fusesource.zk.jmx.editors.MBeanFeatureModeMainFormPage;
import com.fusesource.zk.jmx.model.MBeanAttributeModel;
import javax.management.MBeanAttributeInfo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class MBeanAttributeModelMainFormPage
extends MBeanFeatureModeMainFormPage<MBeanAttributeModel> {
    public static final String ID = MBeanAttributeModelMainFormPage.class.getName();
    public static final String INFO_SECTION_TITLE = "MBeanAttributeInfo";
    public static final String PRIMARY_SECTION_TITLE = "Attribute Value";

    public MBeanAttributeModelMainFormPage(MBeanAttributeModelFormEditor editor) {
        super(editor, ID);
        this.setPrimarySectionTitle(PRIMARY_SECTION_TITLE);
        this.setInfoSectionTitle(INFO_SECTION_TITLE);
    }

    @Override
    protected Section createPrimarySection(ScrolledForm form, Composite client, FormToolkit toolkit) {
        Section primarySection = this.createTableSection(form, client, toolkit, this.getPrimarySectionTitle(), JmxActivator.getManagedImage("IMAGE_KEY_OBJECT_MBEAN_ATTRIBUTE_VALUE"));
        Table primarySectionTable = (Table)primarySection.getClient();
        this.initTableEdit(primarySectionTable, null, 1);
        return primarySection;
    }

    protected MBeanAttributeInfo getAttributeInfo() {
        return (MBeanAttributeInfo)this.getFeatureInfo();
    }

    protected final Table getPrimaryTable() {
        return (Table)this.getPrimarySection().getClient();
    }

    @Override
    protected void initInfoSectionFromModel() {
        super.initInfoSectionFromModel();
        Table table = this.getInfoTable();
        MBeanAttributeInfo attributeInfo = this.getAttributeInfo();
        TableItem item = new TableItem(table, 0);
        item.setText(0, "Type");
        item.setText(1, attributeInfo.getType());
        item = new TableItem(table, 0);
        item.setText(0, "Readable");
        item.setText(1, String.valueOf(attributeInfo.isReadable()));
        item = new TableItem(table, 0);
        item.setText(0, "Writable");
        item.setText(1, String.valueOf(attributeInfo.isWritable()));
        item = new TableItem(table, 0);
        item.setText(0, "Has \"is\" Getter");
        item.setText(1, String.valueOf(attributeInfo.isIs()));
    }

    @Override
    protected void initPrimarySectionFromModel() {
        Table table = this.getPrimaryTable();
        table.removeAll();
        MBeanAttributeModel model = (MBeanAttributeModel)this.getModel();
        MBeanAttribute attribute = (MBeanAttribute)model.getData();
        String valueString = attribute.getValueAsString();
        String valueError = attribute.getValueRetrievalErrorMessage();
        TableItem item = new TableItem(table, 0);
        item.setText(0, attribute.getName());
        if (valueError != null) {
            item.setText(1, valueError);
            item.setForeground(1, table.getDisplay().getSystemColor(3));
        } else {
            item.setText(1, valueString);
        }
        this.packTable(table, DEFAULT_NAME_VALUE_COLUMN_WIDTHS);
    }
}

