/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.editors;

import com.fusesource.zk.core.editors.DataModelFormEditor;
import com.fusesource.zk.jmx.JmxActivator;
import com.fusesource.zk.jmx.data.MBeanFeature;
import com.fusesource.zk.jmx.editors.BaseJmxModelMainFormPage;
import com.fusesource.zk.jmx.jmxdoc.JmxDocFormText;
import com.fusesource.zk.jmx.model.MBeanFeatureModel;
import javax.management.Descriptor;
import javax.management.MBeanFeatureInfo;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class MBeanFeatureModeMainFormPage<M extends MBeanFeatureModel<M, ?>>
extends BaseJmxModelMainFormPage<M> {
    protected static final String FEATURE_INFO_PROPERTY_NAME_NAME = "Name";
    protected static final String FEATURE_INFO_PROPERTY_NAME_DESCRIPTION = "Description";
    public static final String DETAIL_SECTION_TITLE = "Detail";
    private FormText _JmxDocFormText;

    public MBeanFeatureModeMainFormPage(DataModelFormEditor<M> editor, String id) {
        super(editor, id);
    }

    protected MBeanFeatureInfo getFeatureInfo() {
        return ((MBeanFeature)((MBeanFeatureModel)this.getModel()).getData()).getInfo();
    }

    @Override
    protected Descriptor getJmxDescriptor() {
        return this.getFeatureInfo().getDescriptor();
    }

    @Override
    protected void initInfoSectionFromModel() {
        Table table = this.getInfoTable();
        table.removeAll();
        MBeanFeatureInfo featureInfo = this.getFeatureInfo();
        TableItem nameItem = new TableItem(table, 0);
        nameItem.setText(0, FEATURE_INFO_PROPERTY_NAME_NAME);
        nameItem.setText(1, featureInfo.getName());
        TableItem descriptionItem = new TableItem(table, 0);
        descriptionItem.setText(0, FEATURE_INFO_PROPERTY_NAME_DESCRIPTION);
        descriptionItem.setText(1, featureInfo.getDescription());
    }

    @Override
    protected Section createDetailSection(ScrolledForm form, Composite client, FormToolkit toolkit) {
        Section section = this.createSection(form, client, toolkit, DETAIL_SECTION_TITLE, JmxActivator.getManagedImage("IMAGE_KEY_OBJECT_JMX_DOC"));
        Composite sectionClient = this.createSectionClient(section, toolkit);
        this._JmxDocFormText = toolkit.createFormText(sectionClient, false);
        JmxDocFormText.initFormText(this._JmxDocFormText);
        FormData jmxdocFormTextFormData = new FormData();
        jmxdocFormTextFormData.top = new FormAttachment(0, 0);
        jmxdocFormTextFormData.left = new FormAttachment(0, 0);
        this._JmxDocFormText.setLayoutData((Object)jmxdocFormTextFormData);
        GridData detailSectionGridData = new GridData(768);
        section.setLayoutData((Object)detailSectionGridData);
        return section;
    }

    @Override
    protected void initDetailSectionFromModel() {
        if (this._JmxDocFormText != null) {
            String jmxDocFormText = JmxDocFormText.getFormText(((MBeanFeatureModel)this.getModel()).getDoc(), false);
            this._JmxDocFormText.setText(jmxDocFormText, true, false);
        }
    }

    @Override
    protected void initPrimarySectionFromModel() {
    }
}

