/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.jmxdoc;

import com.fusesource.zk.jmx.jmxdoc.JmxType;
import com.fusesource.zk.jmx.jmxdoc.MBeanAttributeDoc;
import com.fusesource.zk.jmx.jmxdoc.MBeanDoc;
import com.fusesource.zk.jmx.jmxdoc.MBeanFeatureDoc;
import com.fusesource.zk.jmx.jmxdoc.MBeanOperationDoc;
import com.fusesource.zk.jmx.jmxdoc.MBeanParameterDoc;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.forms.widgets.FormText;

public final class JmxDocFormText {
    public static final String FONT_CODE_KEY = "code";
    public static final String FONT_H1_KEY = "H1";
    public static final String FONT_H3_KEY = "H3";
    public static final String INDENT = "    ";
    public static final String HEADING_ATTRIBUTE_DETAIL = "Attribute Detail";
    public static final String HEADING_OPERATION_DETAIL = "Operation Detail";
    public static final String HEADING_PARAMETERS = "Parameters:";
    public static final String HEADING_RETURNS = "Returns:";

    public static void initFormText(FormText formText) {
        formText.setWhitespaceNormalized(false);
        Font formTextFont = formText.getFont();
        FontData formTextFontData = formTextFont.getFontData()[0];
        FontData h1FontData = new FontData(formTextFontData.getName(), formTextFontData.getHeight() + 5, 1);
        final Font h1Font = new Font(formTextFont.getDevice(), h1FontData);
        formText.setFont(FONT_H1_KEY, h1Font);
        FontData h3FontData = new FontData(formTextFontData.getName(), formTextFontData.getHeight() + 3, 1);
        final Font h3Font = new Font(formTextFont.getDevice(), h3FontData);
        formText.setFont(FONT_H3_KEY, h3Font);
        Font codeFont = JFaceResources.getTextFont();
        formText.setFont(FONT_CODE_KEY, codeFont);
        formText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                h1Font.dispose();
                h3Font.dispose();
            }
        });
    }

    public static String getFormTextHeader(MBeanFeatureDoc<?> featureDoc) {
        StringBuilder jmxdoc = new StringBuilder();
        jmxdoc.append("<p>");
        jmxdoc.append("<span font=\"H3\">");
        jmxdoc.append(featureDoc.getName());
        jmxdoc.append("</span>");
        jmxdoc.append("</p>");
        return jmxdoc.toString();
    }

    public static String getFormTextDescription(MBeanFeatureDoc<?> featureDoc) {
        StringBuilder jmxdoc = new StringBuilder();
        String name = featureDoc.getRawName();
        String description = featureDoc.getDescription();
        if (description != null && !description.equals(name) && !description.trim().isEmpty()) {
            jmxdoc.append("<p>");
            jmxdoc.append(INDENT);
            jmxdoc.append(description);
            jmxdoc.append("</p>");
        }
        return jmxdoc.toString();
    }

    public static String getFormTextSignature(MBeanOperationDoc operationDoc) {
        StringBuilder jmxdoc = new StringBuilder();
        String name = operationDoc.getName();
        String returnType = operationDoc.getReturnType().getName();
        jmxdoc.append("<p>");
        jmxdoc.append("<span font=\"code\">");
        jmxdoc.append(returnType).append(" ").append(name).append("(");
        List<MBeanParameterDoc> parameters = operationDoc.getParameters();
        int parameterCount = parameters.size();
        int i = 0;
        while (i < parameterCount) {
            MBeanParameterDoc parameter = parameters.get(i);
            String parameterType = parameter.getType().getName();
            String parameterName = parameter.getName();
            jmxdoc.append(parameterType).append(" ").append(parameterName);
            if (i < parameterCount - 1) {
                jmxdoc.append(", ");
            }
            ++i;
        }
        jmxdoc.append(")");
        jmxdoc.append("</span>");
        jmxdoc.append("</p>");
        return jmxdoc.toString();
    }

    public static String getFormTextSignature(MBeanAttributeDoc attributeDoc) {
        StringBuilder jmxdoc = new StringBuilder();
        String name = attributeDoc.getName();
        String returnType = attributeDoc.getType().getName();
        jmxdoc.append("<p>");
        jmxdoc.append("<span font=\"code\">");
        jmxdoc.append(returnType).append(" ").append(name).append("()");
        jmxdoc.append("</span>");
        jmxdoc.append("</p>");
        return jmxdoc.toString();
    }

    public static String getFormTextParameters(MBeanOperationDoc operationDoc) {
        StringBuilder jmxdoc = new StringBuilder();
        List<MBeanParameterDoc> parameters = operationDoc.getParameters();
        int parameterCount = parameters.size();
        if (parameterCount > 0) {
            jmxdoc.append("<p>");
            jmxdoc.append(INDENT);
            jmxdoc.append("<b>");
            jmxdoc.append(HEADING_PARAMETERS);
            jmxdoc.append("</b>");
            jmxdoc.append("</p>");
            jmxdoc.append("<p>");
            int i = 0;
            while (i < parameterCount) {
                MBeanParameterDoc parameter = parameters.get(i);
                String parameterName = parameter.getName();
                String parameterDescription = parameter.getDescription();
                jmxdoc.append(INDENT);
                jmxdoc.append(INDENT);
                jmxdoc.append("<span font=\"code\">");
                jmxdoc.append(parameterName);
                jmxdoc.append("</span>");
                jmxdoc.append(" - ").append(parameterDescription);
                if (i < parameterCount - 1) {
                    jmxdoc.append("<br/>");
                }
                ++i;
            }
            jmxdoc.append("</p>");
        }
        return jmxdoc.toString();
    }

    public static String getFormTextReturns(JmxType returnType) {
        StringBuilder jmxdoc = new StringBuilder();
        String returnTypeString = returnType.getName();
        if (returnTypeString != null && !returnTypeString.equals("void")) {
            jmxdoc.append("<p>");
            jmxdoc.append(INDENT);
            jmxdoc.append("<b>");
            jmxdoc.append(HEADING_RETURNS);
            jmxdoc.append("</b>");
            jmxdoc.append("</p>");
            jmxdoc.append("<p>");
            jmxdoc.append(INDENT);
            jmxdoc.append(INDENT);
            jmxdoc.append("<span font=\"code\">");
            jmxdoc.append(returnTypeString);
            jmxdoc.append("</span>");
            jmxdoc.append("<br/>");
            jmxdoc.append("</p>");
        }
        return jmxdoc.toString();
    }

    public static String getFormText(MBeanDoc mbeanDoc) {
        List<MBeanOperationDoc> operations;
        int operationCount;
        StringBuilder jmxdoc = new StringBuilder();
        jmxdoc.append("<form>");
        List<MBeanAttributeDoc> attributes = mbeanDoc.getAttributes();
        int attributeCount = attributes.size();
        if (attributeCount > 0) {
            jmxdoc.append("<p>");
            jmxdoc.append("<span font=\"H1\">");
            jmxdoc.append(HEADING_ATTRIBUTE_DETAIL);
            jmxdoc.append("</span>");
            jmxdoc.append("</p>");
            int i = 0;
            while (i < attributeCount) {
                MBeanAttributeDoc attributeDoc = attributes.get(i);
                jmxdoc.append(JmxDocFormText.getFormTextHeader(attributeDoc));
                jmxdoc.append(JmxDocFormText.getFormTextSignature(attributeDoc));
                jmxdoc.append(JmxDocFormText.getFormTextDescription(attributeDoc));
                jmxdoc.append(JmxDocFormText.getFormTextReturns(attributeDoc.getType()));
                if (i < attributeCount - 1) {
                    jmxdoc.append("<br/>");
                }
                ++i;
            }
        }
        if ((operationCount = (operations = mbeanDoc.getOperations()).size()) > 0) {
            jmxdoc.append("<p>");
            jmxdoc.append("<span font=\"H1\">");
            jmxdoc.append(HEADING_OPERATION_DETAIL);
            jmxdoc.append("</span>");
            jmxdoc.append("</p>");
            int i = 0;
            while (i < operationCount) {
                MBeanOperationDoc operationDoc = operations.get(i);
                jmxdoc.append(JmxDocFormText.getFormTextHeader(operationDoc));
                jmxdoc.append(JmxDocFormText.getFormTextSignature(operationDoc));
                jmxdoc.append(JmxDocFormText.getFormTextDescription(operationDoc));
                jmxdoc.append(JmxDocFormText.getFormTextParameters(operationDoc));
                jmxdoc.append(JmxDocFormText.getFormTextReturns(operationDoc.getReturnType()));
                if (i < operationCount - 1) {
                    jmxdoc.append("<br/>");
                }
                ++i;
            }
        }
        jmxdoc.append("</form>");
        return jmxdoc.toString();
    }

    public static String getFormText(MBeanFeatureDoc<?> featureDoc, boolean includeHeader) {
        if (featureDoc instanceof MBeanOperationDoc) {
            return JmxDocFormText.getFormText((MBeanOperationDoc)featureDoc, includeHeader);
        }
        if (featureDoc instanceof MBeanAttributeDoc) {
            return JmxDocFormText.getFormText((MBeanAttributeDoc)featureDoc, includeHeader);
        }
        return "<form></form>";
    }

    public static String getFormText(MBeanAttributeDoc attributeDoc, boolean includeHeader) {
        StringBuilder jmxdoc = new StringBuilder();
        jmxdoc.append("<form>");
        if (includeHeader) {
            jmxdoc.append(JmxDocFormText.getFormTextHeader(attributeDoc));
        }
        jmxdoc.append(JmxDocFormText.getFormTextSignature(attributeDoc));
        jmxdoc.append(JmxDocFormText.getFormTextDescription(attributeDoc));
        jmxdoc.append(JmxDocFormText.getFormTextReturns(attributeDoc.getType()));
        jmxdoc.append("</form>");
        return jmxdoc.toString();
    }

    public static String getFormText(MBeanOperationDoc operationDoc, boolean includeHeader) {
        StringBuilder jmxdoc = new StringBuilder();
        jmxdoc.append("<form>");
        if (includeHeader) {
            jmxdoc.append(JmxDocFormText.getFormTextHeader(operationDoc));
        }
        jmxdoc.append(JmxDocFormText.getFormTextSignature(operationDoc));
        jmxdoc.append(JmxDocFormText.getFormTextDescription(operationDoc));
        jmxdoc.append(JmxDocFormText.getFormTextParameters(operationDoc));
        jmxdoc.append(JmxDocFormText.getFormTextReturns(operationDoc.getReturnType()));
        jmxdoc.append("</form>");
        return jmxdoc.toString();
    }
}

