/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.jmxdoc;

import com.fusesource.zk.jmx.jmxdoc.JmxType;
import com.fusesource.zk.jmx.jmxdoc.MBeanFeatureDoc;
import com.fusesource.zk.jmx.jmxdoc.MBeanParameterDoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public final class MBeanOperationDoc
extends MBeanFeatureDoc<MBeanOperationInfo> {
    public static final String IMPACT_ACTION = "ACTION";
    public static final String IMPACT_ACTION_INFO = "ACTION_INFO";
    public static final String IMPACT_INFO = "INFO";
    public static final String IMPACT_UNKNOWN = "UNKNOWN";
    private JmxType _ReturnType;
    private List<MBeanParameterDoc> _Parameters;

    public static String getImpactString(int impact) {
        switch (impact) {
            case 1: {
                return IMPACT_ACTION;
            }
            case 2: {
                return IMPACT_ACTION_INFO;
            }
            case 0: {
                return IMPACT_INFO;
            }
        }
        return IMPACT_UNKNOWN;
    }

    public MBeanOperationDoc(MBeanOperationInfo info) {
        super(info);
    }

    public JmxType getReturnType() {
        if (this._ReturnType == null) {
            this._ReturnType = new JmxType(((MBeanOperationInfo)this.getInfo()).getReturnType(), this.getDescriptor());
        }
        return this._ReturnType;
    }

    public int getImpact() {
        return ((MBeanOperationInfo)this.getInfo()).getImpact();
    }

    public String getImpactString() {
        return MBeanOperationDoc.getImpactString(this.getImpact());
    }

    public List<MBeanParameterDoc> getParameters() {
        if (this._Parameters == null) {
            MBeanParameterInfo[] parameterInfos = ((MBeanOperationInfo)this.getInfo()).getSignature();
            if (parameterInfos == null || parameterInfos.length == 0) {
                return Collections.emptyList();
            }
            this._Parameters = new ArrayList<MBeanParameterDoc>(parameterInfos.length);
            MBeanParameterInfo[] mBeanParameterInfoArray = parameterInfos;
            int n = parameterInfos.length;
            int n2 = 0;
            while (n2 < n) {
                MBeanParameterInfo parameterInfo = mBeanParameterInfoArray[n2];
                MBeanParameterDoc parameterDoc = new MBeanParameterDoc(parameterInfo);
                this._Parameters.add(parameterDoc);
                ++n2;
            }
        }
        return this._Parameters;
    }
}

