/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.jmxdoc;

import com.fusesource.zk.jmx.jmxdoc.JmxType;
import com.fusesource.zk.jmx.jmxdoc.MBeanFeatureDoc;
import java.util.regex.Pattern;
import javax.management.MBeanParameterInfo;

public final class MBeanParameterDoc
extends MBeanFeatureDoc<MBeanParameterInfo> {
    private static final Pattern REGEX_PATTERN_WHITESPACE = Pattern.compile("\\s+");
    private String _Name;
    private JmxType _Type;

    public MBeanParameterDoc(MBeanParameterInfo info) {
        super(info);
    }

    @Override
    public String getName() {
        if (this._Name == null) {
            this._Name = super.getName();
            if (this._Name == null) {
                return this._Name;
            }
            String[] parts = REGEX_PATTERN_WHITESPACE.split(this._Name.trim());
            if (parts.length > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(parts[0]);
                int i = 1;
                while (i < parts.length) {
                    String part = parts[i];
                    sb.append(Character.toUpperCase(part.charAt(0)));
                    sb.append(part.substring(1));
                    ++i;
                }
                this._Name = sb.toString();
            }
        }
        return this._Name;
    }

    public JmxType getType() {
        if (this._Type == null) {
            this._Type = new JmxType(((MBeanParameterInfo)this.getInfo()).getType(), this.getDescriptor());
        }
        return this._Type;
    }
}

