/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.model;

import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.jmx.data.Domain;
import com.fusesource.zk.jmx.data.IObjectNamePart;
import com.fusesource.zk.jmx.data.ObjectNameKeyValue;
import com.fusesource.zk.jmx.model.AbstractJmxModel;
import com.fusesource.zk.jmx.model.DomainModel;
import com.fusesource.zk.jmx.model.JmxConnectionModel;
import com.fusesource.zk.jmx.model.MBeanModel;
import com.fusesource.zk.jmx.model.ObjectNameKeyValueModel;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;

public abstract class AbstractObjectNameKeyValueModel<T extends AbstractObjectNameKeyValueModel<T, K, D>, K extends Comparable<K>, D>
extends AbstractJmxModel<T, K, D> {
    private final DomainModel _DomainModel;

    AbstractObjectNameKeyValueModel(K key, DomainModel domainModel, JmxConnectionModel jmxConnectionModel) {
        super(key, jmxConnectionModel);
        this._DomainModel = domainModel;
    }

    public List<MBeanModel> getChildMBeanModels() {
        return this.getDomainModel().getMBeanModels(this.getObjectNameKeyValue());
    }

    public Set<ObjectName> getChildMBeanObjectNames() {
        return this.getDomainModel().getMBeanObjectNames(this.getObjectNameKeyValue());
    }

    public List<ObjectNameKeyValueModel> getChildObjectNameKeyValueModels() {
        return this.getDomainModel().getObjectNameKeyValueModels(this.getObjectNameKeyValue());
    }

    public Set<String> getChildObjectNameKeyValuePairStrings() {
        return this.getDomainModel().getObjectNameKeyValuePairStrings(this.getObjectNameKeyValue());
    }

    public DomainModel getDomainModel() {
        return this._DomainModel;
    }

    public abstract ObjectNameKeyValue getObjectNameKeyValue();

    public DataModel<?, ?, ?> getParentModel() {
        ObjectNameKeyValue objectNameKeyValue = this.getObjectNameKeyValue();
        IObjectNamePart parentPart = objectNameKeyValue.getParentObjectNamePart();
        if (parentPart instanceof Domain) {
            return this.getDomainModel();
        }
        if (parentPart instanceof ObjectNameKeyValue) {
            ObjectNameKeyValue parentKeyValue = (ObjectNameKeyValue)parentPart;
            if (parentKeyValue.isMBean()) {
                return this.getDomainModel().getMBeanModel(parentKeyValue.getObjectName());
            }
            return this.getDomainModel().getObjectNameKeyValueModel(parentKeyValue.getKeyValuePairString());
        }
        return null;
    }
}

