/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.model;

import com.fusesource.zk.core.model.DataModelSourceException;
import com.fusesource.zk.core.model.OperationNotSupportedException;
import com.fusesource.zk.jmx.data.Domain;
import com.fusesource.zk.jmx.data.IObjectNamePart;
import com.fusesource.zk.jmx.data.ObjectNameKeyValue;
import com.fusesource.zk.jmx.model.AbstractJmxModelSource;
import com.fusesource.zk.jmx.model.AbstractObjectNameKeyValueModel;
import com.fusesource.zk.jmx.model.DomainModel;
import com.fusesource.zk.jmx.model.JmxConnectionModel;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractObjectNameKeyValueModelSource<M extends AbstractObjectNameKeyValueModel<M, K, D>, K extends Comparable<K>, D>
extends AbstractJmxModelSource<M, K, D> {
    private final DomainModel _DomainModel;

    public AbstractObjectNameKeyValueModelSource(DomainModel domainModel, JmxConnectionModel jmxConnectionModel) {
        super(jmxConnectionModel);
        this._DomainModel = domainModel;
    }

    public Set<K> findKeys(Object criteria) throws DataModelSourceException {
        if (criteria instanceof IObjectNamePart) {
            IObjectNamePart iObjectNamePart = (IObjectNamePart)criteria;
            return this.getKeys(iObjectNamePart.getChildObjectNameKeyValues());
        }
        throw new OperationNotSupportedException();
    }

    public DomainModel getDomainModel() {
        return this._DomainModel;
    }

    public boolean isFindKeysSupported(Object criteria) {
        return criteria instanceof IObjectNamePart;
    }

    protected Domain getDomain() {
        return (Domain)this._DomainModel.getData();
    }

    protected abstract K getKey(ObjectNameKeyValue var1);

    private Set<K> getKeys(List<ObjectNameKeyValue> childObjectNameKeyValues) {
        if (childObjectNameKeyValues == null) {
            return null;
        }
        TreeSet<K> keys = new TreeSet<K>();
        for (ObjectNameKeyValue childObjectNameKeyValue : childObjectNameKeyValues) {
            K key = this.getKey(childObjectNameKeyValue);
            if (key == null) continue;
            keys.add(key);
        }
        return keys;
    }
}

