/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.model;

import com.fusesource.zk.core.model.DataModelSourceException;
import com.fusesource.zk.jmx.data.Domain;
import com.fusesource.zk.jmx.data.JmxConnection;
import com.fusesource.zk.jmx.model.AbstractJmxModelSource;
import com.fusesource.zk.jmx.model.DomainModel;
import com.fusesource.zk.jmx.model.JmxConnectionModel;
import java.util.Set;

public class DomainModelSource
extends AbstractJmxModelSource<DomainModel, String, Domain> {
    public DomainModelSource(JmxConnectionModel jmxConnectionModel) {
        super(jmxConnectionModel);
    }

    public Domain getData(String domainName) {
        return this.getJmxConnection().getDomain(domainName);
    }

    public Set<String> getKeys() throws DataModelSourceException {
        JmxConnection jmxConnection = this.getJmxConnection();
        return jmxConnection.getDomainNames();
    }

    public boolean isGetKeysSupported() {
        return true;
    }

    protected DomainModel createModelInternal(String domainName) {
        return new DomainModel(domainName, this.getJmxConnectionModel());
    }
}

