/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.model;

import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.core.model.DataModelManager;
import com.fusesource.zk.core.model.IDataModelSource;
import com.fusesource.zk.jmx.data.Domain;
import com.fusesource.zk.jmx.data.IJmxConnectionEventListener;
import com.fusesource.zk.jmx.data.JmxConnection;
import com.fusesource.zk.jmx.data.JmxConnectionDescriptor;
import com.fusesource.zk.jmx.data.JmxConnectionEvent;
import com.fusesource.zk.jmx.model.DomainModel;
import com.fusesource.zk.jmx.model.DomainModelSource;
import com.fusesource.zk.jmx.model.MBeanModel;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;

public final class JmxConnectionModel
extends DataModel<JmxConnectionModel, JmxConnectionDescriptor, JmxConnection> {
    private DataModelManager<DomainModel, String, Domain> _DomainModelManager;
    private final JmxConnectionListener _JmxConnectionListener;
    private final Object _Owner;

    JmxConnectionModel(JmxConnectionDescriptor jmxConnectionDescriptor, Object owner) {
        super((Comparable)((Object)jmxConnectionDescriptor));
        this._Owner = owner;
        this._JmxConnectionListener = new JmxConnectionListener();
    }

    public DomainModel getDomainModel(String domainName) {
        return (DomainModel)this._DomainModelManager.getModel((Comparable)((Object)domainName));
    }

    public List<DomainModel> getDomainModels() {
        return this._DomainModelManager.getModels();
    }

    public Set<String> getDomainNames() {
        return this._DomainModelManager.getKeys();
    }

    public Object getOwner() {
        return this._Owner;
    }

    public DataModel<?, ?, ?> getOwnerModel() {
        Object owner = this.getOwner();
        if (owner instanceof DataModel) {
            return (DataModel)owner;
        }
        return null;
    }

    public DataModel<?, ?, ?> getParentModel() {
        return this.getOwnerModel();
    }

    protected JmxConnectionModel getThis() {
        return this;
    }

    protected void hookAfterDestroyed() {
        if (this._DomainModelManager != null) {
            this._DomainModelManager.destroy();
        }
        JmxConnection jmxConnection = (JmxConnection)this.getData();
        jmxConnection.close();
    }

    protected void hookAfterSetData() {
        JmxConnection jmxConnection = (JmxConnection)this.getData();
        if (jmxConnection != null) {
            jmxConnection.addEventListener(this._JmxConnectionListener);
            if (this.hasListeners()) {
                jmxConnection.connect();
            }
        }
        if (this._DomainModelManager == null) {
            DomainModelSource domainModelSource = new DomainModelSource(this);
            this._DomainModelManager = new DataModelManager((IDataModelSource)domainModelSource);
        } else {
            this._DomainModelManager.refreshManagedModels();
        }
    }

    protected void hookBeforeFirstListenerAdded() {
        super.hookBeforeFirstListenerAdded();
        JmxConnection jmxConnection = (JmxConnection)this.getData();
        jmxConnection.connect();
    }

    protected void hookBeforeSetData() {
        JmxConnection jmxConnection = (JmxConnection)this.getData();
        if (jmxConnection != null) {
            jmxConnection.removeEventListener(this._JmxConnectionListener);
            jmxConnection.close();
        }
    }

    private class JmxConnectionListener
    implements IJmxConnectionEventListener {
        private JmxConnectionListener() {
        }

        @Override
        public void mbeanRegistered(JmxConnectionEvent event) {
            ObjectName objectName = event.getObjectName();
            List domainModels = JmxConnectionModel.this._DomainModelManager.getManagedModels();
            if (domainModels == null) {
                return;
            }
            for (DomainModel domainModel : domainModels) {
                Domain domain = (Domain)domainModel.getData();
                ObjectName domainPattern = domain.getDomainPatternObjectName();
                if (!domainPattern.apply(objectName)) continue;
                domainModel.refreshData();
                return;
            }
        }

        @Override
        public void mbeanUnregistered(JmxConnectionEvent event) {
            ObjectName objectName = event.getObjectName();
            List domainModels = JmxConnectionModel.this._DomainModelManager.getManagedModels();
            if (domainModels == null) {
                return;
            }
            for (DomainModel domainModel : domainModels) {
                MBeanModel mbeanModel;
                Domain domain = (Domain)domainModel.getData();
                ObjectName domainPattern = domain.getDomainPatternObjectName();
                if (!domainPattern.apply(objectName) || (mbeanModel = domainModel.getMBeanModel(objectName)) == null) continue;
                mbeanModel.destroy();
                return;
            }
        }

        @Override
        public void connectionStateChanged(JmxConnectionEvent event) {
            JmxConnectionModel.this.fireDataModelDataChanged();
            JmxConnection connection = (JmxConnection)JmxConnectionModel.this.getData();
            if (!connection.isConnected()) {
                JmxConnectionModel.this._DomainModelManager.destroyManagedModels();
            }
        }
    }
}

