/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.model;

import com.fusesource.zk.core.model.DataModelSourceException;
import com.fusesource.zk.jmx.data.JmxConnection;
import com.fusesource.zk.jmx.data.MBean;
import com.fusesource.zk.jmx.data.MBeanFeature;
import com.fusesource.zk.jmx.model.AbstractJmxModelSource;
import com.fusesource.zk.jmx.model.JmxConnectionModel;
import com.fusesource.zk.jmx.model.MBeanFeatureModel;
import com.fusesource.zk.jmx.model.MBeanModel;

public abstract class MBeanFeatureModelSource<M extends MBeanFeatureModel<M, D>, D extends MBeanFeature<?>>
extends AbstractJmxModelSource<M, String, D> {
    private final MBeanModel _MBeanModel;

    public MBeanFeatureModelSource(MBeanModel mbeanModel, JmxConnectionModel jmxConnectionModel) {
        super(jmxConnectionModel);
        this._MBeanModel = mbeanModel;
    }

    public final D getData(String featureName) throws DataModelSourceException {
        MBean mbean = this.getMBean();
        JmxConnection jmxConnection = this.getJmxConnection();
        return this.getMBeanFeature(jmxConnection, mbean, featureName);
    }

    public MBeanModel getMBeanModel() {
        return this._MBeanModel;
    }

    public boolean isGetKeysSupported() {
        return true;
    }

    protected MBean getMBean() {
        return (MBean)this._MBeanModel.getData();
    }

    protected abstract D getMBeanFeature(JmxConnection var1, MBean var2, String var3);
}

