/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.model;

import com.fusesource.zk.core.model.DataModelManager;
import com.fusesource.zk.core.model.IDataModelSource;
import com.fusesource.zk.jmx.data.Domain;
import com.fusesource.zk.jmx.data.MBean;
import com.fusesource.zk.jmx.data.MBeanAttribute;
import com.fusesource.zk.jmx.data.MBeanOperation;
import com.fusesource.zk.jmx.data.ObjectNameKeyValue;
import com.fusesource.zk.jmx.jmxdoc.MBeanDoc;
import com.fusesource.zk.jmx.model.AbstractObjectNameKeyValueModel;
import com.fusesource.zk.jmx.model.DomainModel;
import com.fusesource.zk.jmx.model.JmxConnectionModel;
import com.fusesource.zk.jmx.model.MBeanAttributeModel;
import com.fusesource.zk.jmx.model.MBeanAttributeModelSource;
import com.fusesource.zk.jmx.model.MBeanAttributesModelCategory;
import com.fusesource.zk.jmx.model.MBeanOperationModel;
import com.fusesource.zk.jmx.model.MBeanOperationModelSource;
import com.fusesource.zk.jmx.model.MBeanOperationsModelCategory;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;

public final class MBeanModel
extends AbstractObjectNameKeyValueModel<MBeanModel, ObjectName, MBean> {
    private final DataModelManager<MBeanAttributeModel, String, MBeanAttribute> _MBeanAttributeModelManager;
    private final MBeanAttributesModelCategory _MBeanAttributesModelCategory;
    private final DataModelManager<MBeanOperationModel, String, MBeanOperation> _MBeanOperationModelManager;
    private final MBeanOperationsModelCategory _MBeanOperationsModelCategory;

    MBeanModel(ObjectName objectName, DomainModel domainModel, JmxConnectionModel jmxConnectionModel) {
        super(objectName, domainModel, jmxConnectionModel);
        MBeanAttributeModelSource mbeanAttributeModelSource = new MBeanAttributeModelSource(this, jmxConnectionModel);
        this._MBeanAttributeModelManager = new DataModelManager((IDataModelSource)mbeanAttributeModelSource);
        MBeanOperationModelSource mbeanOperationModelSource = new MBeanOperationModelSource(this, jmxConnectionModel);
        this._MBeanOperationModelManager = new DataModelManager((IDataModelSource)mbeanOperationModelSource);
        this._MBeanAttributesModelCategory = new MBeanAttributesModelCategory(this);
        this._MBeanOperationsModelCategory = new MBeanOperationsModelCategory(this);
    }

    public MBeanAttributeModel getAttributeModel(String attributeName) {
        return (MBeanAttributeModel)this._MBeanAttributeModelManager.getModel((Comparable)((Object)attributeName));
    }

    public List<MBeanAttributeModel> getAttributeModels() {
        return this._MBeanAttributeModelManager.getModels();
    }

    public Set<String> getAttributeNames() {
        return this._MBeanAttributeModelManager.getKeys();
    }

    public MBeanAttributesModelCategory getAttributesModelCategory() {
        return this._MBeanAttributesModelCategory;
    }

    @Override
    public ObjectNameKeyValue getObjectNameKeyValue() {
        return ((Domain)this.getDomainModel().getData()).getMBeanObjectNameKeyValue((ObjectName)this.getKey());
    }

    public MBeanOperationModel getOperationModel(String operationName) {
        return (MBeanOperationModel)this._MBeanOperationModelManager.getModel((Comparable)((Object)operationName));
    }

    public List<MBeanOperationModel> getOperationModels() {
        return this._MBeanOperationModelManager.getModels();
    }

    public Set<String> getOperationNames() {
        return this._MBeanOperationModelManager.getKeys();
    }

    public MBeanOperationsModelCategory getOperationsModelCategory() {
        return this._MBeanOperationsModelCategory;
    }

    protected MBeanModel getThis() {
        return this;
    }

    protected void hookAfterDestroyed() {
        this._MBeanAttributeModelManager.destroy();
        this._MBeanOperationModelManager.destroy();
    }

    public MBeanDoc getDoc() {
        return new MBeanDoc(((MBean)this.getData()).getInfo());
    }
}

