/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.model;

import com.fusesource.zk.core.model.DataModelSourceException;
import com.fusesource.zk.jmx.data.Domain;
import com.fusesource.zk.jmx.data.JmxConnection;
import com.fusesource.zk.jmx.data.MBean;
import com.fusesource.zk.jmx.data.ObjectNameKeyValue;
import com.fusesource.zk.jmx.model.AbstractObjectNameKeyValueModelSource;
import com.fusesource.zk.jmx.model.DomainModel;
import com.fusesource.zk.jmx.model.JmxConnectionModel;
import com.fusesource.zk.jmx.model.MBeanModel;
import java.util.Set;
import javax.management.ObjectName;

public class MBeanModelSource
extends AbstractObjectNameKeyValueModelSource<MBeanModel, ObjectName, MBean> {
    public MBeanModelSource(DomainModel domainModel, JmxConnectionModel jmxConnectionModel) {
        super(domainModel, jmxConnectionModel);
    }

    public MBean getData(ObjectName objectName) throws DataModelSourceException {
        Domain domain = this.getDomain();
        Set<ObjectName> mbeanObjectNames = domain.getMBeanObjectNames();
        if (!mbeanObjectNames.contains(objectName)) {
            return null;
        }
        JmxConnection jmxConnection = this.getJmxConnection();
        return jmxConnection.getMBean(objectName);
    }

    public Set<ObjectName> getKeys() throws DataModelSourceException {
        return this.getDomain().getMBeanObjectNames();
    }

    public boolean isGetKeysSupported() {
        return true;
    }

    protected MBeanModel createModelInternal(ObjectName objectName) {
        return new MBeanModel(objectName, this.getDomainModel(), this.getJmxConnectionModel());
    }

    @Override
    protected ObjectName getKey(ObjectNameKeyValue objectNameKeyValue) {
        if (!objectNameKeyValue.isMBean()) {
            return null;
        }
        return objectNameKeyValue.getObjectName();
    }
}

