/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.model;

import com.fusesource.zk.core.model.DataModelSourceException;
import com.fusesource.zk.jmx.data.Domain;
import com.fusesource.zk.jmx.data.ObjectNameKeyValue;
import com.fusesource.zk.jmx.model.AbstractObjectNameKeyValueModelSource;
import com.fusesource.zk.jmx.model.DomainModel;
import com.fusesource.zk.jmx.model.JmxConnectionModel;
import com.fusesource.zk.jmx.model.ObjectNameKeyValueModel;

public class ObjectNameKeyValueModelSource
extends AbstractObjectNameKeyValueModelSource<ObjectNameKeyValueModel, String, ObjectNameKeyValue> {
    public ObjectNameKeyValueModelSource(DomainModel domainModel, JmxConnectionModel jmxConnectionModel) {
        super(domainModel, jmxConnectionModel);
    }

    public ObjectNameKeyValue getData(String keyValuePairString) throws DataModelSourceException {
        Domain domain = this.getDomain();
        ObjectNameKeyValue objectNameKeyValue = domain.getObjectNameKeyValue(keyValuePairString);
        if (objectNameKeyValue == null || objectNameKeyValue.isMBean()) {
            return null;
        }
        return objectNameKeyValue;
    }

    protected ObjectNameKeyValueModel createModelInternal(String keyValuePairString) {
        return new ObjectNameKeyValueModel(keyValuePairString, this.getDomainModel(), this.getJmxConnectionModel());
    }

    @Override
    protected String getKey(ObjectNameKeyValue objectNameKeyValue) {
        if (objectNameKeyValue.isMBean()) {
            return null;
        }
        return objectNameKeyValue.getKeyValuePairString();
    }
}

