/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.runtime;

import com.fusesource.zk.core.runtime.ConnectionDescriptorFiles;
import com.fusesource.zk.core.runtime.IConnectionDescriptorXmlSerializer;
import com.fusesource.zk.jmx.data.JmxConnectionDescriptor;
import java.io.File;
import java.net.MalformedURLException;
import javax.management.remote.JMXServiceURL;
import org.eclipse.ui.XMLMemento;

public final class JmxConnectionDescriptorFiles
extends ConnectionDescriptorFiles<JmxConnectionDescriptor> {
    public static final String XML_VERSION_1 = "1";
    public static final String XML_WRITE_VERSION = "1";
    private static final String XML_TAG_JMX_URL = "JmxUrl";
    private static final String XML_TAG_USER_NAME = "UserName";
    private static final String XML_TAG_PASSWORD = "Password";

    public JmxConnectionDescriptorFiles(File directory) {
        super(directory, "1");
        this.addSerializer("1", new Version1Serializer());
    }

    private class Version1Serializer
    implements IConnectionDescriptorXmlSerializer<JmxConnectionDescriptor> {
        private Version1Serializer() {
        }

        public JmxConnectionDescriptor fromXml(XMLMemento memento) {
            String name = memento.getString("Name");
            String jmxServiceUrlString = memento.getString(JmxConnectionDescriptorFiles.XML_TAG_JMX_URL);
            String userName = memento.getString(JmxConnectionDescriptorFiles.XML_TAG_USER_NAME);
            String password = memento.getString(JmxConnectionDescriptorFiles.XML_TAG_PASSWORD);
            JMXServiceURL jmxServiceUrl = null;
            try {
                jmxServiceUrl = new JMXServiceURL(jmxServiceUrlString);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            JmxConnectionDescriptor connectionDescriptor = new JmxConnectionDescriptor(name, jmxServiceUrl, userName, password);
            return connectionDescriptor;
        }

        public void toXml(JmxConnectionDescriptor connectionDescriptor, XMLMemento memento) {
            String password;
            memento.putString(JmxConnectionDescriptorFiles.XML_TAG_JMX_URL, String.valueOf(connectionDescriptor.getJmxServiceUrl()));
            String userName = connectionDescriptor.getUserName();
            if (userName != null) {
                memento.putString(JmxConnectionDescriptorFiles.XML_TAG_USER_NAME, userName);
            }
            if ((password = connectionDescriptor.getPassword()) != null) {
                memento.putString(JmxConnectionDescriptorFiles.XML_TAG_PASSWORD, password);
            }
        }
    }
}

