/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.viewers;

import com.fusesource.zk.jmx.JmxActivator;
import com.fusesource.zk.jmx.data.Domain;
import com.fusesource.zk.jmx.model.DomainModel;
import com.fusesource.zk.jmx.model.MBeanModel;
import com.fusesource.zk.jmx.model.ObjectNameKeyValueModel;
import com.fusesource.zk.jmx.viewers.AbstractJmxDataModelElementType;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.eclipse.swt.graphics.Image;

public class DomainModelElementType
extends AbstractJmxDataModelElementType {
    public static final String PROPERTY_NAME_NAME = "Name";
    public static final String PROPERTY_NAME_MBEAN_COUNT = "MBean Count";
    private static final int[] COLUMN_ALIGNMENTS = new int[]{16384, 131072};
    private static final String[] COLUMN_TITLES = new String[]{"Name", "MBean Count"};
    private static final int[] COLUMN_WIDTHS = new int[]{-1, -1};

    public int[] getColumnAlignments() {
        return COLUMN_ALIGNMENTS;
    }

    public String getColumnText(Object element, int columnIndex) {
        DomainModel model = (DomainModel)((Object)element);
        Domain domain = (Domain)model.getData();
        switch (columnIndex) {
            case 0: {
                return domain.getName();
            }
            case 1: {
                int mbeanCount = 0;
                Set<ObjectName> objectNames = domain.getMBeanObjectNames();
                if (objectNames != null) {
                    mbeanCount = objectNames.size();
                }
                return String.valueOf(mbeanCount);
            }
        }
        return null;
    }

    public String[] getColumnTitles() {
        return COLUMN_TITLES;
    }

    public int[] getColumnWidths() {
        return COLUMN_WIDTHS;
    }

    public int getChildCount(Object parent) {
        Set<ObjectName> mbeanObjectNames;
        int childCount = 0;
        DomainModel model = (DomainModel)((Object)parent);
        Set<String> objectNameKeyValuePairStrings = model.getObjectNameKeyValuePairStrings();
        if (objectNameKeyValuePairStrings != null) {
            childCount += objectNameKeyValuePairStrings.size();
        }
        if ((mbeanObjectNames = model.getRootMBeanObjectNames()) != null) {
            childCount += mbeanObjectNames.size();
        }
        return childCount;
    }

    public Object getChildElement(Object parent, int index) {
        DomainModel model = (DomainModel)((Object)parent);
        int objectNameKeyValueModelCount = 0;
        List<ObjectNameKeyValueModel> objectNameKeyValueModels = model.getObjectNameKeyValueModels();
        if (objectNameKeyValueModels != null) {
            objectNameKeyValueModelCount = objectNameKeyValueModels.size();
        }
        if (index < objectNameKeyValueModelCount) {
            return objectNameKeyValueModels.get(index);
        }
        int mbeanModelCount = 0;
        List<MBeanModel> mbeanModels = model.getRootMBeanModels();
        if (mbeanModels != null) {
            mbeanModelCount = mbeanModels.size();
        }
        if (index < objectNameKeyValueModelCount + mbeanModelCount) {
            return mbeanModels.get(index - objectNameKeyValueModelCount);
        }
        return null;
    }

    public Image getImage(Object element) {
        return JmxActivator.getManagedImage("IMAGE_KEY_OBJECT_MBEAN_DOMAIN");
    }

    public Image getLargeImage(Object element) {
        return JmxActivator.getManagedImage("IMAGE_KEY_OBJECT_MBEAN_DOMAIN_LARGE");
    }

    public String getText(Object element) {
        DomainModel model = (DomainModel)((Object)element);
        String text = ((Domain)model.getData()).getName();
        return text;
    }
}

