/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.viewers;

import com.fusesource.zk.jmx.JmxActivator;
import com.fusesource.zk.jmx.data.JmxConnection;
import com.fusesource.zk.jmx.data.JmxConnectionDescriptor;
import com.fusesource.zk.jmx.model.DomainModel;
import com.fusesource.zk.jmx.model.JmxConnectionModel;
import com.fusesource.zk.jmx.viewers.AbstractJmxDataModelElementType;
import java.util.List;
import java.util.Set;
import javax.management.remote.JMXServiceURL;
import org.eclipse.swt.graphics.Image;

public class JmxConnectionModelElementType
extends AbstractJmxDataModelElementType {
    public int getChildCount(Object parent) {
        JmxConnectionModel model = (JmxConnectionModel)((Object)parent);
        JmxConnection connection = (JmxConnection)model.getData();
        if (!connection.isConnected()) {
            return 0;
        }
        Set<String> domainNames = model.getDomainNames();
        int childCount = 0;
        if (domainNames != null) {
            childCount = domainNames.size();
        }
        return childCount;
    }

    public Object getChildElement(Object parent, int index) {
        JmxConnectionModel model = (JmxConnectionModel)((Object)parent);
        JmxConnection connection = (JmxConnection)model.getData();
        if (!connection.isConnected()) {
            return null;
        }
        List<DomainModel> domainModels = model.getDomainModels();
        if (domainModels != null && index < domainModels.size()) {
            return domainModels.get(index);
        }
        return null;
    }

    public Image getImage(Object element) {
        JmxConnectionModel model = (JmxConnectionModel)((Object)element);
        if (model != null && !((JmxConnection)model.getData()).isConnected()) {
            return JmxActivator.getManagedImage("IMAGE_KEY_OBJECT_JMX_CONNECTION_NOT_CONNECTED");
        }
        return JmxActivator.getManagedImage("IMAGE_KEY_OBJECT_JMX_CONNECTION");
    }

    public Image getLargeImage(Object element) {
        JmxConnectionModel model = (JmxConnectionModel)((Object)element);
        if (model != null && !((JmxConnection)model.getData()).isConnected()) {
            return JmxActivator.getManagedImage("IMAGE_KEY_OBJECT_JMX_CONNECTION_NOT_CONNECTED_LARGE");
        }
        return JmxActivator.getManagedImage("IMAGE_KEY_OBJECT_JMX_CONNECTION_LARGE");
    }

    public String getText(Object element) {
        JmxConnectionModel model = (JmxConnectionModel)((Object)element);
        if (model.getOwner() == null) {
            return ((JmxConnectionDescriptor)((Object)model.getKey())).getName();
        }
        JMXServiceURL jmxServiceURL = ((JmxConnectionDescriptor)((Object)model.getKey())).getJmxServiceUrl();
        String host = jmxServiceURL.getHost();
        String urlPath = jmxServiceURL.getURLPath();
        if (host != null && !host.isEmpty() || urlPath == null) {
            return String.valueOf(jmxServiceURL);
        }
        return urlPath;
    }

    public String getToolTipText(Object element) {
        JmxConnectionModel model = (JmxConnectionModel)((Object)element);
        return String.valueOf(((JmxConnectionDescriptor)((Object)model.getKey())).getJmxServiceUrl());
    }
}

